---
title: Scenarios
---

# We need your Help!

Building a scenario is a lot of work. If you have built a SUMO scenario
you can share (under a sufficiently open license), please
[contact us](../Contact.md).

# Alicante-Murcia highway scenario
Large-scale and high-accuracy traffic simulation scenario that models 9 full days of traffic over a 97 km freeway section, with mixed traffic (light and heavy vehicles). The simulation scenario has been calibrated using a unique dataset provided by the Spanish road authority and a novel learning-based and iterative traffic demand calibration technique for SUMO.

More info at: https://github.com/msepulcre/Alicante-Murcia-SUMO-Scenario

# Berlin

- [Mosaic Berlin Sumo Traffic (BeST) Scenario on GitHub](https://github.com/mosaic-addons/best-scenario)

# Bologna

A small-scale scenario based on the city of Bologna. The large
roundabout can be found at 44.494554,11.314393. These scenarios were
developed as part of the [iTETRIS project](https://www.ict-itetris.eu). A
[publication](https://elib.dlr.de/89354) on these scenarios was presented
at [SUMO
Conference 2014](https://sumo.dlr.de/docs/Publications.html#SUMO_2014): L.
Bieker, D. Krajzewicz, A. Morra, C. Michelacci and F. Cartolano,
"Traffic simulation for all: a real world traffic scenario from the city
of Bologna", SUMO2014, p 19-26

- [Bologna Scenario on GitHub](https://github.com/DLR-TS/sumo-scenarios/tree/main/bologna/)
- (Old release) [Download .zip files from SourceForge](https://sourceforge.net/projects/sumo/files/traffic_data/scenarios/Bologna_small)

# Braunschweig

- [Brunswick Scenario on GitHub](https://github.com/DLR-TS/sumo-scenarios/tree/main/brunswick)

# Dublin - Irish Motorway, National road and city centre

- [Main Page](https://github.com/maxime-gueriau/ITSC2020_CAV_impact)
- Publication: Quantifying the impact of connected and autonomous vehicles on traffic efficiency and safety in mixed traffic" by Maxime Gueriau and Ivana Dusparic, presented at the 23rd IEEE International Conference on Intelligent Transportation Systems (ITSC 2020)

# Geneva - Digital Twin - Geneva Motorway (DT-GM)

- [Repository](https://github.com/SiLab-group/DigitalTwin_GenevaMotorway)

Everyone (after registering at ODPMS) can get access to fine-grained (minute resolution) real-time traffic data from traffic counters and use it as input in DT-GM.
The details of modelling and results will also be publicly available in two papers, which for the moment we only mentioned in the README file since they are under review process. (if need it we can provide you preprint of the paper "Building a Motorway Digital Twin in SUMO: Real-Time Simulation of Continuous Data Stream from Traffic Counters")

# Ingolstadt traffic scenario
## InTAS

- [Main Page](https://github.com/silaslobo/InTAS)
- [Presentation video](https://www.youtube.com/watch?v=UgPeBxXzDHc)

## SUMO Ingolstadt
Created in the SAVe:, SAVeNoW and KIVI research projects
- [Main Page](https://github.com/TUM-VT/sumo_ingolstadt)

# Luxembourg SUMO Traffic (LuST)

- [Main Page](https://github.com/lcodeca/LuSTScenario)
- [Releases](https://github.com/lcodeca/LuSTScenario/releases)
- [Documentation](https://github.com/lcodeca/LuSTScenario/blob/master/docs/LuSTDocumentation.md)
- Publication: Lara CODECA, Raphael FRANK, Thomas ENGEL. December 2015. Luxembourg SUMO Traffic (LuST) Scenario: 24 Hours of Mobility
for Vehicular Networking Research in Proceedings of the 7th IEEE
Vehicular Networking Conference (VNC15).

# Monaco SUMO Traffic (MoST)

- [Main Page](https://github.com/lcodeca/MoSTScenario)
- [Releases](https://github.com/lcodeca/MoSTScenario/releases)
- Publication: L. Codeca, J. Härri, "Towards Multimodal Mobility
Simulation of C-ITS: The Monaco SUMO Traffic Scenario" VNC 2017,
IEEE Vehicular Networking Conference November 27-29, 2017, Torino,
Italy.

# Stuttgart Open Motorway Project (STOMP)

- [Main Page](https://github.com/boschresearch/stuttgart-sumo-traffic-scenario)
- Publication: David Förster, Hans Löhr, Anne Grätz, Jonathan Petit, and Frank Kargl, "An Evaluation of Pseudonym Changes for Vehicular Networks in Large-scale, Realistic Traffic Scenarios", IEEE Transactions on Intelligent Transportation Systems 19.10 (2017): 3400-3405, doi: [10.1109/TITS.2017.2775519](https://doi.org/10.1109/TITS.2017.2775519).

# Toronto

- [**TorontoSUMONetworks on GitHub**](https://github.com/Jahandad-Baloch/TorontoSUMONetworks)

TorontoSUMONetworks is an open-source platform designed for creating, manipulating, and simulating traffic networks in Toronto using SUMO. This tool provides a realistic simulation environment for transportation research, urban planning, and traffic management. Its flexibility makes it valuable for diverse research areas, including Intelligent Transportation Systems (ITS), Reinforcement Learning for Adaptive Traffic Signal Control (ATSC), and more.

Key Features:
- Realistic traffic simulations based on the Toronto network, including major arterials and local streets.
- Multi-modal transportation support, simulating private vehicles, buses, bicycles, and pedestrians.
- Utilizes real-world data from the City of Toronto Open Data Portal for accurate simulations.
- Highly configurable, supporting detectors like inductionloop, lanearea, and multi-entry/exit for traffic management.

This project offers a comprehensive platform for researchers, urban planners, and engineers aiming to improve urban mobility and optimize traffic systems through advanced simulation and analysis.

# Turin SUMO Traffic (TuST)
A large-scale mesoscopic traffic simulation of a 600-sqkm area around the Municipality of Turin.

- [Main Page](https://github.com/marcorapelli/TuSTScenario)
- Publications:
  - M. Rapelli, C. Casetti and G. Gagliardi, “Vehicular Traffic Simulation in the City of Turin from Raw Data” in IEEE Transactions on Mobile Computing, April 2021. DOI: 10.1109/TMC.2021.3075985 [pre-print](https://ieeexplore.ieee.org/document/9416842)
  - M. Rapelli, C. Casetti and G. Gagliardi, "TuST: from Raw Data to Vehicular Traffic Simulation in Turin," 2019 IEEE/ACM 23rd International Symposium on Distributed Simulation and Real Time Applications (DS-RT), Cosenza, Italy, 2019, pp. 1-8, doi: 10.1109/DS-RT47707.2019.8958652. [pre-print](https://ieeexplore.ieee.org/document/8958652)

!!! note
    It requires [git-lfs](https://git-lfs.github.com/) to download

![TuST.png](../images/TuST.gif "TuST")

# TAPASCologne

![ssnap_TapasCologne_0.1.gif](../images/Ssnap_TapasCologne_0.1.gif
"TAPAS Cologne")
The "TAPAS Cologne" simulation scenario
describes the traffic within the city of Cologne, Germany for a whole
day. The original demand data stems from TAPAS, a system which computes
mobility wishes for an area population generated based on information
about travelling habits of Germans and on information about the
infrastructure of the area they live in.

More information about the system can be found within this [publication
on TAPAS](https://elib.dlr.de/45058/02/SRL_81_-_Beitrag_Varschen.pdf).
The original data was using a closed-source road network and was mapped
onto one stemming from the [OpenStreetMap
project](https://www.openstreetmap.de/).

There is further information about
[TAPASCologne](../Data/Scenarios/TAPASCologne.md).

# TAVF-Hamburg

A scenario from the [TAVF](https://tavf.hamburg/en/) test track for automated and
connected driving in Hamburg.

- [TAVF-Hamburg Scenario on GitHub](https://github.com/DLR-TS/sumo-scenarios/tree/main/TAVF-Hamburg)

# Boston, Lisbon, Los Angeles, Rio de Janeiro, San Francisco

[SUMO simulation files for running 24h of car traffic in five large-scale cities](https://www.research-collection.ethz.ch/handle/20.500.11850/584669)

# Outdated real-world scenarios

- [Bologna Ringway](https://web.archive.org/web/20220707045650/https://academic.lucabedogni.it/the-bologna-ringway-dataset/).
    Scenario built within the [COLOMBO R&D
    project](https://web.archive.org/web/20170716120720/https://www.colombo-fp7.eu/).

!!! caution
    This scenario seems to have been removed and is only here for historical reference. It was known to have lots of collisions due to unsafe traffic lights and some invalid junction definitions. It is also quite jammed.

# Synthetic scenarios

Synthetic - or abstract - scenarios only resemble typical layouts of
real-world junctions and arterials without mapping a very specific one.
Some synthetic scenarios of the [COLOMBO R&D
project](https://web.archive.org/web/20170716120720/https://www.colombo-fp7.eu/) are examples of the German guideline
RiLSA. They are described in [D1.1 "Scenario Specifications and Required
Modifications to Simulation
Tools"](https://web.archive.org/web/20170808122505/https://elib.dlr.de/98046/1/COLOMBO_D1.1_ScenariosExtensions_v2.4.pdf)(chapter
4).

- Download: [4 RiLSA \*.zip files](https://sourceforge.net/projects/sumo/files/traffic_data/scenarios/RiLSA)

# Wildau

This scenario can be followed as a tutorial - it showcases how routes can be generated within a network, using counting data.

- [Wildau Scenario on GitHub](https://github.com/DLR-TS/sumo-scenarios/tree/main/Wildau)

# Test cases

SUMO comes with a large set of tests which are run at least once per day (and most are run on each repository commit).
You can [extract them](../Tutorials/index.md#using_examples_from_the_test_suite) and use them as basis for your own (small) scenarios.
