# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hdinsightcontainers import HDInsightContainersMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHDInsightContainersMgmtClusterPoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HDInsightContainersMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.cluster_pools.get(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.cluster_pools.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_pool={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "computeProfile": {"vmSize": "str", "availabilityZones": ["str"], "count": 0},
                    "aksClusterProfile": {
                        "aksClusterAgentPoolIdentityProfile": {
                            "msiClientId": "str",
                            "msiObjectId": "str",
                            "msiResourceId": "str",
                        },
                        "aksClusterResourceId": "str",
                        "aksVersion": "str",
                    },
                    "aksManagedResourceGroupName": "str",
                    "clusterPoolProfile": {
                        "clusterPoolVersion": "str",
                        "publicIpTag": {"ipTagType": "str", "tag": "str"},
                    },
                    "deploymentId": "str",
                    "logAnalyticsProfile": {"enabled": bool, "workspaceId": "str"},
                    "managedResourceGroupName": "str",
                    "networkProfile": {
                        "subnetId": "str",
                        "apiServerAuthorizedIpRanges": ["str"],
                        "enablePrivateApiServer": bool,
                        "outboundType": "loadBalancer",
                    },
                    "provisioningState": "str",
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update_tags(self, resource_group):
        response = self.client.cluster_pools.begin_update_tags(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_pool_tags={"tags": {"str": "str"}},
            api_version="2024-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.cluster_pools.begin_delete(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            api_version="2024-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.cluster_pools.list_by_subscription(
            api_version="2024-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.cluster_pools.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_upgrade(self, resource_group):
        response = self.client.cluster_pools.begin_upgrade(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_pool_upgrade_request={"properties": "cluster_pool_upgrade_properties"},
            api_version="2024-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
