# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementWebAppsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list(self, resource_group):
        response = self.client.web_apps.list(
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_by_resource_group(self, resource_group):
        response = self.client.web_apps.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get(self, resource_group):
        response = self.client.web_apps.get(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_or_update(self, resource_group):
        response = self.client.web_apps.begin_create_or_update(
            resource_group_name=resource_group.name,
            name="str",
            site_envelope={
                "location": "str",
                "autoGeneratedDomainNameLabelScope": "str",
                "availabilityState": "str",
                "clientAffinityEnabled": bool,
                "clientAffinityPartitioningEnabled": bool,
                "clientAffinityProxyEnabled": bool,
                "clientCertEnabled": bool,
                "clientCertExclusionPaths": "str",
                "clientCertMode": "str",
                "cloningInfo": {
                    "sourceWebAppId": "str",
                    "appSettingsOverrides": {"str": "str"},
                    "cloneCustomHostNames": bool,
                    "cloneSourceControl": bool,
                    "configureLoadBalancing": bool,
                    "correlationId": "str",
                    "hostingEnvironment": "str",
                    "overwrite": bool,
                    "sourceWebAppLocation": "str",
                    "trafficManagerProfileId": "str",
                    "trafficManagerProfileName": "str",
                },
                "containerSize": 0,
                "customDomainVerificationId": "str",
                "dailyMemoryTimeQuota": 0,
                "daprConfig": {
                    "appId": "str",
                    "appPort": 0,
                    "enableApiLogging": bool,
                    "enabled": False,
                    "httpMaxRequestSize": 0,
                    "httpReadBufferSize": 0,
                    "logLevel": "str",
                },
                "defaultHostName": "str",
                "dnsConfiguration": {
                    "dnsAltServer": "str",
                    "dnsLegacySortOrder": bool,
                    "dnsMaxCacheTimeout": 0,
                    "dnsRetryAttemptCount": 0,
                    "dnsRetryAttemptTimeout": 0,
                    "dnsServers": ["str"],
                },
                "enabled": bool,
                "enabledHostNames": ["str"],
                "endToEndEncryptionEnabled": bool,
                "extendedLocation": {"name": "str", "type": "str"},
                "functionAppConfig": {
                    "deployment": {
                        "storage": {
                            "authentication": {
                                "storageAccountConnectionStringName": "str",
                                "type": "str",
                                "userAssignedIdentityResourceId": "str",
                            },
                            "type": "str",
                            "value": "str",
                        }
                    },
                    "runtime": {"name": "str", "version": "str"},
                    "scaleAndConcurrency": {
                        "alwaysReady": [{"instanceCount": 0, "name": "str"}],
                        "instanceMemoryMB": 0,
                        "maximumInstanceCount": 0,
                        "triggers": {"http": {"perInstanceConcurrency": 0}},
                    },
                },
                "hostNameSslStates": [
                    {
                        "hostType": "str",
                        "name": "str",
                        "sslState": "str",
                        "thumbprint": "str",
                        "toUpdate": bool,
                        "virtualIP": "str",
                    }
                ],
                "hostNames": ["str"],
                "hostNamesDisabled": bool,
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "httpsOnly": bool,
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inProgressOperationId": "str",
                "ipMode": "str",
                "isDefaultContainer": bool,
                "isXenon": False,
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "lastModifiedTimeUtc": "2020-02-20 00:00:00",
                "managedEnvironmentId": "str",
                "maxNumberOfWorkers": 0,
                "name": "str",
                "outboundIpAddresses": "str",
                "outboundVnetRouting": {
                    "allTraffic": bool,
                    "applicationTraffic": bool,
                    "backupRestoreTraffic": bool,
                    "contentShareTraffic": bool,
                    "imagePullTraffic": bool,
                },
                "possibleOutboundIpAddresses": "str",
                "publicNetworkAccess": "str",
                "redundancyMode": "str",
                "repositorySiteName": "str",
                "reserved": False,
                "resourceConfig": {"cpu": 0.0, "memory": "str"},
                "resourceGroup": "str",
                "scmSiteAlsoStopped": False,
                "serverFarmId": "str",
                "siteConfig": {
                    "acrUseManagedIdentityCreds": bool,
                    "acrUserManagedIdentityID": "str",
                    "alwaysOn": bool,
                    "apiDefinition": {"url": "str"},
                    "apiManagementConfig": {"id": "str"},
                    "appCommandLine": "str",
                    "appSettings": [{"name": "str", "value": "str"}],
                    "autoHealEnabled": bool,
                    "autoHealRules": {
                        "actions": {
                            "actionType": "str",
                            "customAction": {"exe": "str", "parameters": "str"},
                            "minProcessExecutionTime": "str",
                        },
                        "triggers": {
                            "privateBytesInKB": 0,
                            "requests": {"count": 0, "timeInterval": "str"},
                            "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                            "slowRequestsWithPath": [
                                {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                            ],
                            "statusCodes": [
                                {
                                    "count": 0,
                                    "path": "str",
                                    "status": 0,
                                    "subStatus": 0,
                                    "timeInterval": "str",
                                    "win32Status": 0,
                                }
                            ],
                            "statusCodesRange": [
                                {"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}
                            ],
                        },
                    },
                    "autoSwapSlotName": "str",
                    "azureStorageAccounts": {
                        "str": {
                            "accessKey": "str",
                            "accountName": "str",
                            "mountPath": "str",
                            "protocol": "str",
                            "shareName": "str",
                            "state": "str",
                            "type": "str",
                        }
                    },
                    "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                    "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                    "defaultDocuments": ["str"],
                    "detailedErrorLoggingEnabled": bool,
                    "documentRoot": "str",
                    "elasticWebAppScaleLimit": 0,
                    "experiments": {
                        "rampUpRules": [
                            {
                                "actionHostName": "str",
                                "changeDecisionCallbackUrl": "str",
                                "changeIntervalInMinutes": 0,
                                "changeStep": 0.0,
                                "maxReroutePercentage": 0.0,
                                "minReroutePercentage": 0.0,
                                "name": "str",
                                "reroutePercentage": 0.0,
                            }
                        ]
                    },
                    "ftpsState": "str",
                    "functionAppScaleLimit": 0,
                    "functionsRuntimeScaleMonitoringEnabled": bool,
                    "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                    "healthCheckPath": "str",
                    "http20Enabled": True,
                    "http20ProxyFlag": 0,
                    "httpLoggingEnabled": bool,
                    "ipSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "ipSecurityRestrictionsDefaultAction": "str",
                    "javaContainer": "str",
                    "javaContainerVersion": "str",
                    "javaVersion": "str",
                    "keyVaultReferenceIdentity": "str",
                    "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                    "linuxFxVersion": "str",
                    "loadBalancing": "str",
                    "localMySqlEnabled": False,
                    "logsDirectorySizeLimit": 0,
                    "machineKey": {
                        "decryption": "str",
                        "decryptionKey": "str",
                        "validation": "str",
                        "validationKey": "str",
                    },
                    "managedPipelineMode": "str",
                    "managedServiceIdentityId": 0,
                    "metadata": [{"name": "str", "value": "str"}],
                    "minTlsCipherSuite": "str",
                    "minTlsVersion": "str",
                    "minimumElasticInstanceCount": 0,
                    "netFrameworkVersion": "v4.6",
                    "nodeVersion": "str",
                    "numberOfWorkers": 0,
                    "phpVersion": "str",
                    "powerShellVersion": "str",
                    "preWarmedInstanceCount": 0,
                    "publicNetworkAccess": "str",
                    "publishingUsername": "str",
                    "push": {
                        "dynamicTagsJson": "str",
                        "id": "str",
                        "isPushEnabled": bool,
                        "kind": "str",
                        "name": "str",
                        "tagWhitelistJson": "str",
                        "tagsRequiringAuth": "str",
                        "type": "str",
                    },
                    "pythonVersion": "str",
                    "remoteDebuggingEnabled": bool,
                    "remoteDebuggingVersion": "str",
                    "requestTracingEnabled": bool,
                    "requestTracingExpirationTime": "2020-02-20 00:00:00",
                    "scmIpSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "scmIpSecurityRestrictionsDefaultAction": "str",
                    "scmIpSecurityRestrictionsUseMain": bool,
                    "scmMinTlsVersion": "str",
                    "scmType": "str",
                    "tracingOptions": "str",
                    "use32BitWorkerProcess": bool,
                    "virtualApplications": [
                        {
                            "physicalPath": "str",
                            "preloadEnabled": bool,
                            "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                            "virtualPath": "str",
                        }
                    ],
                    "vnetName": "str",
                    "vnetPrivatePortsCount": 0,
                    "vnetRouteAllEnabled": bool,
                    "webSocketsEnabled": bool,
                    "websiteTimeZone": "str",
                    "windowsFxVersion": "str",
                    "xManagedServiceIdentityId": 0,
                },
                "sku": "str",
                "slotSwapStatus": {
                    "destinationSlotName": "str",
                    "sourceSlotName": "str",
                    "timestampUtc": "2020-02-20 00:00:00",
                },
                "sshEnabled": bool,
                "state": "str",
                "storageAccountRequired": bool,
                "suspendedTill": "2020-02-20 00:00:00",
                "tags": {"str": "str"},
                "targetSwapSlot": "str",
                "trafficManagerHostNames": ["str"],
                "type": "str",
                "usageState": "str",
                "virtualNetworkSubnetId": "str",
                "workloadProfileName": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete(self, resource_group):
        response = self.client.web_apps.delete(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update(self, resource_group):
        response = self.client.web_apps.update(
            resource_group_name=resource_group.name,
            name="str",
            site_envelope={
                "availabilityState": "str",
                "clientAffinityEnabled": bool,
                "clientAffinityProxyEnabled": bool,
                "clientCertEnabled": bool,
                "clientCertExclusionPaths": "str",
                "clientCertMode": "str",
                "cloningInfo": {
                    "sourceWebAppId": "str",
                    "appSettingsOverrides": {"str": "str"},
                    "cloneCustomHostNames": bool,
                    "cloneSourceControl": bool,
                    "configureLoadBalancing": bool,
                    "correlationId": "str",
                    "hostingEnvironment": "str",
                    "overwrite": bool,
                    "sourceWebAppLocation": "str",
                    "trafficManagerProfileId": "str",
                    "trafficManagerProfileName": "str",
                },
                "containerSize": 0,
                "customDomainVerificationId": "str",
                "dailyMemoryTimeQuota": 0,
                "defaultHostName": "str",
                "dnsConfiguration": {
                    "dnsAltServer": "str",
                    "dnsLegacySortOrder": bool,
                    "dnsMaxCacheTimeout": 0,
                    "dnsRetryAttemptCount": 0,
                    "dnsRetryAttemptTimeout": 0,
                    "dnsServers": ["str"],
                },
                "enabled": bool,
                "enabledHostNames": ["str"],
                "hostNameSslStates": [
                    {
                        "hostType": "str",
                        "name": "str",
                        "sslState": "str",
                        "thumbprint": "str",
                        "toUpdate": bool,
                        "virtualIP": "str",
                    }
                ],
                "hostNames": ["str"],
                "hostNamesDisabled": bool,
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "httpsOnly": bool,
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inProgressOperationId": "str",
                "isDefaultContainer": bool,
                "isXenon": False,
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "lastModifiedTimeUtc": "2020-02-20 00:00:00",
                "maxNumberOfWorkers": 0,
                "name": "str",
                "outboundIpAddresses": "str",
                "possibleOutboundIpAddresses": "str",
                "redundancyMode": "str",
                "repositorySiteName": "str",
                "reserved": False,
                "resourceGroup": "str",
                "scmSiteAlsoStopped": False,
                "serverFarmId": "str",
                "siteConfig": {
                    "acrUseManagedIdentityCreds": bool,
                    "acrUserManagedIdentityID": "str",
                    "alwaysOn": bool,
                    "apiDefinition": {"url": "str"},
                    "apiManagementConfig": {"id": "str"},
                    "appCommandLine": "str",
                    "appSettings": [{"name": "str", "value": "str"}],
                    "autoHealEnabled": bool,
                    "autoHealRules": {
                        "actions": {
                            "actionType": "str",
                            "customAction": {"exe": "str", "parameters": "str"},
                            "minProcessExecutionTime": "str",
                        },
                        "triggers": {
                            "privateBytesInKB": 0,
                            "requests": {"count": 0, "timeInterval": "str"},
                            "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                            "slowRequestsWithPath": [
                                {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                            ],
                            "statusCodes": [
                                {
                                    "count": 0,
                                    "path": "str",
                                    "status": 0,
                                    "subStatus": 0,
                                    "timeInterval": "str",
                                    "win32Status": 0,
                                }
                            ],
                            "statusCodesRange": [
                                {"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}
                            ],
                        },
                    },
                    "autoSwapSlotName": "str",
                    "azureStorageAccounts": {
                        "str": {
                            "accessKey": "str",
                            "accountName": "str",
                            "mountPath": "str",
                            "protocol": "str",
                            "shareName": "str",
                            "state": "str",
                            "type": "str",
                        }
                    },
                    "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                    "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                    "defaultDocuments": ["str"],
                    "detailedErrorLoggingEnabled": bool,
                    "documentRoot": "str",
                    "elasticWebAppScaleLimit": 0,
                    "experiments": {
                        "rampUpRules": [
                            {
                                "actionHostName": "str",
                                "changeDecisionCallbackUrl": "str",
                                "changeIntervalInMinutes": 0,
                                "changeStep": 0.0,
                                "maxReroutePercentage": 0.0,
                                "minReroutePercentage": 0.0,
                                "name": "str",
                                "reroutePercentage": 0.0,
                            }
                        ]
                    },
                    "ftpsState": "str",
                    "functionAppScaleLimit": 0,
                    "functionsRuntimeScaleMonitoringEnabled": bool,
                    "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                    "healthCheckPath": "str",
                    "http20Enabled": True,
                    "http20ProxyFlag": 0,
                    "httpLoggingEnabled": bool,
                    "ipSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "ipSecurityRestrictionsDefaultAction": "str",
                    "javaContainer": "str",
                    "javaContainerVersion": "str",
                    "javaVersion": "str",
                    "keyVaultReferenceIdentity": "str",
                    "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                    "linuxFxVersion": "str",
                    "loadBalancing": "str",
                    "localMySqlEnabled": False,
                    "logsDirectorySizeLimit": 0,
                    "machineKey": {
                        "decryption": "str",
                        "decryptionKey": "str",
                        "validation": "str",
                        "validationKey": "str",
                    },
                    "managedPipelineMode": "str",
                    "managedServiceIdentityId": 0,
                    "metadata": [{"name": "str", "value": "str"}],
                    "minTlsCipherSuite": "str",
                    "minTlsVersion": "str",
                    "minimumElasticInstanceCount": 0,
                    "netFrameworkVersion": "v4.6",
                    "nodeVersion": "str",
                    "numberOfWorkers": 0,
                    "phpVersion": "str",
                    "powerShellVersion": "str",
                    "preWarmedInstanceCount": 0,
                    "publicNetworkAccess": "str",
                    "publishingUsername": "str",
                    "push": {
                        "dynamicTagsJson": "str",
                        "id": "str",
                        "isPushEnabled": bool,
                        "kind": "str",
                        "name": "str",
                        "tagWhitelistJson": "str",
                        "tagsRequiringAuth": "str",
                        "type": "str",
                    },
                    "pythonVersion": "str",
                    "remoteDebuggingEnabled": bool,
                    "remoteDebuggingVersion": "str",
                    "requestTracingEnabled": bool,
                    "requestTracingExpirationTime": "2020-02-20 00:00:00",
                    "scmIpSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "scmIpSecurityRestrictionsDefaultAction": "str",
                    "scmIpSecurityRestrictionsUseMain": bool,
                    "scmMinTlsVersion": "str",
                    "scmType": "str",
                    "tracingOptions": "str",
                    "use32BitWorkerProcess": bool,
                    "virtualApplications": [
                        {
                            "physicalPath": "str",
                            "preloadEnabled": bool,
                            "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                            "virtualPath": "str",
                        }
                    ],
                    "vnetName": "str",
                    "vnetPrivatePortsCount": 0,
                    "vnetRouteAllEnabled": bool,
                    "webSocketsEnabled": bool,
                    "websiteTimeZone": "str",
                    "windowsFxVersion": "str",
                    "xManagedServiceIdentityId": 0,
                },
                "slotSwapStatus": {
                    "destinationSlotName": "str",
                    "sourceSlotName": "str",
                    "timestampUtc": "2020-02-20 00:00:00",
                },
                "state": "str",
                "storageAccountRequired": bool,
                "suspendedTill": "2020-02-20 00:00:00",
                "targetSwapSlot": "str",
                "trafficManagerHostNames": ["str"],
                "type": "str",
                "usageState": "str",
                "virtualNetworkSubnetId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_analyze_custom_hostname(self, resource_group):
        response = self.client.web_apps.analyze_custom_hostname(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_apply_slot_config_to_production(self, resource_group):
        response = self.client.web_apps.apply_slot_config_to_production(
            resource_group_name=resource_group.name,
            name="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_backup(self, resource_group):
        response = self.client.web_apps.backup(
            resource_group_name=resource_group.name,
            name="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_backups(self, resource_group):
        response = self.client.web_apps.list_backups(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_backup_status(self, resource_group):
        response = self.client.web_apps.get_backup_status(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_backup(self, resource_group):
        response = self.client.web_apps.delete_backup(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_backup_status_secrets(self, resource_group):
        response = self.client.web_apps.list_backup_status_secrets(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore(self, resource_group):
        response = self.client.web_apps.begin_restore(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_basic_publishing_credentials_policies(self, resource_group):
        response = self.client.web_apps.list_basic_publishing_credentials_policies(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ftp_allowed(self, resource_group):
        response = self.client.web_apps.get_ftp_allowed(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_ftp_allowed(self, resource_group):
        response = self.client.web_apps.update_ftp_allowed(
            resource_group_name=resource_group.name,
            name="str",
            csm_publishing_access_policies_entity={
                "allow": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_scm_allowed(self, resource_group):
        response = self.client.web_apps.get_scm_allowed(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_scm_allowed(self, resource_group):
        response = self.client.web_apps.update_scm_allowed(
            resource_group_name=resource_group.name,
            name="str",
            csm_publishing_access_policies_entity={
                "allow": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_configurations(self, resource_group):
        response = self.client.web_apps.list_configurations(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_application_settings(self, resource_group):
        response = self.client.web_apps.update_application_settings(
            resource_group_name=resource_group.name,
            name="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_application_settings(self, resource_group):
        response = self.client.web_apps.list_application_settings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_auth_settings(self, resource_group):
        response = self.client.web_apps.update_auth_settings(
            resource_group_name=resource_group.name,
            name="str",
            site_auth_settings={
                "aadClaimsAuthorization": "str",
                "additionalLoginParams": ["str"],
                "allowedAudiences": ["str"],
                "allowedExternalRedirectUrls": ["str"],
                "authFilePath": "str",
                "clientId": "str",
                "clientSecret": "str",
                "clientSecretCertificateThumbprint": "str",
                "clientSecretSettingName": "str",
                "configVersion": "str",
                "defaultProvider": "str",
                "enabled": bool,
                "facebookAppId": "str",
                "facebookAppSecret": "str",
                "facebookAppSecretSettingName": "str",
                "facebookOAuthScopes": ["str"],
                "gitHubClientId": "str",
                "gitHubClientSecret": "str",
                "gitHubClientSecretSettingName": "str",
                "gitHubOAuthScopes": ["str"],
                "googleClientId": "str",
                "googleClientSecret": "str",
                "googleClientSecretSettingName": "str",
                "googleOAuthScopes": ["str"],
                "id": "str",
                "isAuthFromFile": "str",
                "issuer": "str",
                "kind": "str",
                "microsoftAccountClientId": "str",
                "microsoftAccountClientSecret": "str",
                "microsoftAccountClientSecretSettingName": "str",
                "microsoftAccountOAuthScopes": ["str"],
                "name": "str",
                "runtimeVersion": "str",
                "tokenRefreshExtensionHours": 0.0,
                "tokenStoreEnabled": bool,
                "twitterConsumerKey": "str",
                "twitterConsumerSecret": "str",
                "twitterConsumerSecretSettingName": "str",
                "type": "str",
                "unauthenticatedClientAction": "str",
                "validateIssuer": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings(self, resource_group):
        response = self.client.web_apps.get_auth_settings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings_v2_without_secrets(self, resource_group):
        response = self.client.web_apps.get_auth_settings_v2_without_secrets(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_auth_settings_v2(self, resource_group):
        response = self.client.web_apps.update_auth_settings_v2(
            resource_group_name=resource_group.name,
            name="str",
            site_auth_settings_v2={
                "globalValidation": {
                    "excludedPaths": ["str"],
                    "redirectToProvider": "str",
                    "requireAuthentication": bool,
                    "unauthenticatedClientAction": "str",
                },
                "httpSettings": {
                    "forwardProxy": {
                        "convention": "str",
                        "customHostHeaderName": "str",
                        "customProtoHeaderName": "str",
                    },
                    "requireHttps": bool,
                    "routes": {"apiPrefix": "str"},
                },
                "id": "str",
                "identityProviders": {
                    "apple": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "azureActiveDirectory": {
                        "enabled": bool,
                        "isAutoProvisioned": bool,
                        "login": {"disableWWWAuthenticate": bool, "loginParameters": ["str"]},
                        "registration": {
                            "clientId": "str",
                            "clientSecretCertificateIssuer": "str",
                            "clientSecretCertificateSubjectAlternativeName": "str",
                            "clientSecretCertificateThumbprint": "str",
                            "clientSecretSettingName": "str",
                            "openIdIssuer": "str",
                        },
                        "validation": {
                            "allowedAudiences": ["str"],
                            "defaultAuthorizationPolicy": {
                                "allowedApplications": ["str"],
                                "allowedPrincipals": {"groups": ["str"], "identities": ["str"]},
                            },
                            "jwtClaimChecks": {"allowedClientApplications": ["str"], "allowedGroups": ["str"]},
                        },
                    },
                    "azureStaticWebApps": {"enabled": bool, "registration": {"clientId": "str"}},
                    "customOpenIdConnectProviders": {
                        "str": {
                            "enabled": bool,
                            "login": {"nameClaimType": "str", "scopes": ["str"]},
                            "registration": {
                                "clientCredential": {"clientSecretSettingName": "str", "method": "ClientSecretPost"},
                                "clientId": "str",
                                "openIdConnectConfiguration": {
                                    "authorizationEndpoint": "str",
                                    "certificationUri": "str",
                                    "issuer": "str",
                                    "tokenEndpoint": "str",
                                    "wellKnownOpenIdConfiguration": "str",
                                },
                            },
                        }
                    },
                    "facebook": {
                        "enabled": bool,
                        "graphApiVersion": "str",
                        "login": {"scopes": ["str"]},
                        "registration": {"appId": "str", "appSecretSettingName": "str"},
                    },
                    "gitHub": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "google": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                        "validation": {"allowedAudiences": ["str"]},
                    },
                    "legacyMicrosoftAccount": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                        "validation": {"allowedAudiences": ["str"]},
                    },
                    "twitter": {
                        "enabled": bool,
                        "registration": {"consumerKey": "str", "consumerSecretSettingName": "str"},
                    },
                },
                "kind": "str",
                "login": {
                    "allowedExternalRedirectUrls": ["str"],
                    "cookieExpiration": {"convention": "str", "timeToExpiration": "str"},
                    "nonce": {"nonceExpirationInterval": "str", "validateNonce": bool},
                    "preserveUrlFragmentsForLogins": bool,
                    "routes": {"logoutEndpoint": "str"},
                    "tokenStore": {
                        "azureBlobStorage": {"sasUrlSettingName": "str"},
                        "enabled": bool,
                        "fileSystem": {"directory": "str"},
                        "tokenRefreshExtensionHours": 0.0,
                    },
                },
                "name": "str",
                "platform": {"configFilePath": "str", "enabled": bool, "runtimeVersion": "str"},
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings_v2(self, resource_group):
        response = self.client.web_apps.get_auth_settings_v2(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_azure_storage_accounts(self, resource_group):
        response = self.client.web_apps.update_azure_storage_accounts(
            resource_group_name=resource_group.name,
            name="str",
            azure_storage_accounts={
                "id": "str",
                "kind": "str",
                "name": "str",
                "properties": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_azure_storage_accounts(self, resource_group):
        response = self.client.web_apps.list_azure_storage_accounts(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_backup_configuration(self, resource_group):
        response = self.client.web_apps.update_backup_configuration(
            resource_group_name=resource_group.name,
            name="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_backup_configuration(self, resource_group):
        response = self.client.web_apps.delete_backup_configuration(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_backup_configuration(self, resource_group):
        response = self.client.web_apps.get_backup_configuration(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_app_settings_key_vault_references(self, resource_group):
        response = self.client.web_apps.get_app_settings_key_vault_references(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_app_setting_key_vault_reference(self, resource_group):
        response = self.client.web_apps.get_app_setting_key_vault_reference(
            resource_group_name=resource_group.name,
            name="str",
            app_setting_key="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_connection_string_key_vault_references(self, resource_group):
        response = self.client.web_apps.get_site_connection_string_key_vault_references(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_connection_string_key_vault_reference(self, resource_group):
        response = self.client.web_apps.get_site_connection_string_key_vault_reference(
            resource_group_name=resource_group.name,
            name="str",
            connection_string_key="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_connection_strings(self, resource_group):
        response = self.client.web_apps.update_connection_strings(
            resource_group_name=resource_group.name,
            name="str",
            connection_strings={
                "id": "str",
                "kind": "str",
                "name": "str",
                "properties": {"str": {"type": "str", "value": "str"}},
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_connection_strings(self, resource_group):
        response = self.client.web_apps.list_connection_strings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_diagnostic_logs_configuration(self, resource_group):
        response = self.client.web_apps.get_diagnostic_logs_configuration(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_diagnostic_logs_config(self, resource_group):
        response = self.client.web_apps.update_diagnostic_logs_config(
            resource_group_name=resource_group.name,
            name="str",
            site_logs_config={
                "applicationLogs": {
                    "azureBlobStorage": {"level": "str", "retentionInDays": 0, "sasUrl": "str"},
                    "azureTableStorage": {"sasUrl": "str", "level": "str"},
                    "fileSystem": {"level": "str"},
                },
                "detailedErrorMessages": {"enabled": bool},
                "failedRequestsTracing": {"enabled": bool},
                "httpLogs": {
                    "azureBlobStorage": {"enabled": bool, "retentionInDays": 0, "sasUrl": "str"},
                    "fileSystem": {"enabled": bool, "retentionInDays": 0, "retentionInMb": 0},
                },
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_metadata(self, resource_group):
        response = self.client.web_apps.update_metadata(
            resource_group_name=resource_group.name,
            name="str",
            metadata={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_metadata(self, resource_group):
        response = self.client.web_apps.list_metadata(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_list_publishing_credentials(self, resource_group):
        response = self.client.web_apps.begin_list_publishing_credentials(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_site_push_settings(self, resource_group):
        response = self.client.web_apps.update_site_push_settings(
            resource_group_name=resource_group.name,
            name="str",
            push_settings={
                "dynamicTagsJson": "str",
                "id": "str",
                "isPushEnabled": bool,
                "kind": "str",
                "name": "str",
                "tagWhitelistJson": "str",
                "tagsRequiringAuth": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_push_settings(self, resource_group):
        response = self.client.web_apps.list_site_push_settings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_slot_configuration_names(self, resource_group):
        response = self.client.web_apps.list_slot_configuration_names(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_slot_configuration_names(self, resource_group):
        response = self.client.web_apps.update_slot_configuration_names(
            resource_group_name=resource_group.name,
            name="str",
            slot_config_names={
                "appSettingNames": ["str"],
                "azureStorageConfigNames": ["str"],
                "connectionStringNames": ["str"],
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_configuration(self, resource_group):
        response = self.client.web_apps.get_configuration(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_configuration(self, resource_group):
        response = self.client.web_apps.create_or_update_configuration(
            resource_group_name=resource_group.name,
            name="str",
            site_config={
                "acrUseManagedIdentityCreds": bool,
                "acrUserManagedIdentityID": "str",
                "alwaysOn": bool,
                "apiDefinition": {"url": "str"},
                "apiManagementConfig": {"id": "str"},
                "appCommandLine": "str",
                "appSettings": [{"name": "str", "value": "str"}],
                "autoHealEnabled": bool,
                "autoHealRules": {
                    "actions": {
                        "actionType": "str",
                        "customAction": {"exe": "str", "parameters": "str"},
                        "minProcessExecutionTime": "str",
                    },
                    "triggers": {
                        "privateBytesInKB": 0,
                        "requests": {"count": 0, "timeInterval": "str"},
                        "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                        "slowRequestsWithPath": [
                            {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                        ],
                        "statusCodes": [
                            {
                                "count": 0,
                                "path": "str",
                                "status": 0,
                                "subStatus": 0,
                                "timeInterval": "str",
                                "win32Status": 0,
                            }
                        ],
                        "statusCodesRange": [{"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}],
                    },
                },
                "autoSwapSlotName": "str",
                "azureStorageAccounts": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                "defaultDocuments": ["str"],
                "detailedErrorLoggingEnabled": bool,
                "documentRoot": "str",
                "elasticWebAppScaleLimit": 0,
                "experiments": {
                    "rampUpRules": [
                        {
                            "actionHostName": "str",
                            "changeDecisionCallbackUrl": "str",
                            "changeIntervalInMinutes": 0,
                            "changeStep": 0.0,
                            "maxReroutePercentage": 0.0,
                            "minReroutePercentage": 0.0,
                            "name": "str",
                            "reroutePercentage": 0.0,
                        }
                    ]
                },
                "ftpsState": "str",
                "functionAppScaleLimit": 0,
                "functionsRuntimeScaleMonitoringEnabled": bool,
                "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                "healthCheckPath": "str",
                "http20Enabled": True,
                "http20ProxyFlag": 0,
                "httpLoggingEnabled": bool,
                "id": "str",
                "ipSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "ipSecurityRestrictionsDefaultAction": "str",
                "javaContainer": "str",
                "javaContainerVersion": "str",
                "javaVersion": "str",
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                "linuxFxVersion": "str",
                "loadBalancing": "str",
                "localMySqlEnabled": False,
                "logsDirectorySizeLimit": 0,
                "machineKey": {
                    "decryption": "str",
                    "decryptionKey": "str",
                    "validation": "str",
                    "validationKey": "str",
                },
                "managedPipelineMode": "str",
                "managedServiceIdentityId": 0,
                "metadata": [{"name": "str", "value": "str"}],
                "minTlsCipherSuite": "str",
                "minTlsVersion": "str",
                "minimumElasticInstanceCount": 0,
                "name": "str",
                "netFrameworkVersion": "v4.6",
                "nodeVersion": "str",
                "numberOfWorkers": 0,
                "phpVersion": "str",
                "powerShellVersion": "str",
                "preWarmedInstanceCount": 0,
                "publicNetworkAccess": "str",
                "publishingUsername": "str",
                "push": {
                    "dynamicTagsJson": "str",
                    "id": "str",
                    "isPushEnabled": bool,
                    "kind": "str",
                    "name": "str",
                    "tagWhitelistJson": "str",
                    "tagsRequiringAuth": "str",
                    "type": "str",
                },
                "pythonVersion": "str",
                "remoteDebuggingEnabled": bool,
                "remoteDebuggingVersion": "str",
                "requestTracingEnabled": bool,
                "requestTracingExpirationTime": "2020-02-20 00:00:00",
                "scmIpSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "scmIpSecurityRestrictionsDefaultAction": "str",
                "scmIpSecurityRestrictionsUseMain": bool,
                "scmMinTlsVersion": "str",
                "scmType": "str",
                "tracingOptions": "str",
                "type": "str",
                "use32BitWorkerProcess": bool,
                "virtualApplications": [
                    {
                        "physicalPath": "str",
                        "preloadEnabled": bool,
                        "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                        "virtualPath": "str",
                    }
                ],
                "vnetName": "str",
                "vnetPrivatePortsCount": 0,
                "vnetRouteAllEnabled": bool,
                "webSocketsEnabled": bool,
                "websiteTimeZone": "str",
                "windowsFxVersion": "str",
                "xManagedServiceIdentityId": 0,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_configuration(self, resource_group):
        response = self.client.web_apps.update_configuration(
            resource_group_name=resource_group.name,
            name="str",
            site_config={
                "acrUseManagedIdentityCreds": bool,
                "acrUserManagedIdentityID": "str",
                "alwaysOn": bool,
                "apiDefinition": {"url": "str"},
                "apiManagementConfig": {"id": "str"},
                "appCommandLine": "str",
                "appSettings": [{"name": "str", "value": "str"}],
                "autoHealEnabled": bool,
                "autoHealRules": {
                    "actions": {
                        "actionType": "str",
                        "customAction": {"exe": "str", "parameters": "str"},
                        "minProcessExecutionTime": "str",
                    },
                    "triggers": {
                        "privateBytesInKB": 0,
                        "requests": {"count": 0, "timeInterval": "str"},
                        "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                        "slowRequestsWithPath": [
                            {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                        ],
                        "statusCodes": [
                            {
                                "count": 0,
                                "path": "str",
                                "status": 0,
                                "subStatus": 0,
                                "timeInterval": "str",
                                "win32Status": 0,
                            }
                        ],
                        "statusCodesRange": [{"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}],
                    },
                },
                "autoSwapSlotName": "str",
                "azureStorageAccounts": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                "defaultDocuments": ["str"],
                "detailedErrorLoggingEnabled": bool,
                "documentRoot": "str",
                "elasticWebAppScaleLimit": 0,
                "experiments": {
                    "rampUpRules": [
                        {
                            "actionHostName": "str",
                            "changeDecisionCallbackUrl": "str",
                            "changeIntervalInMinutes": 0,
                            "changeStep": 0.0,
                            "maxReroutePercentage": 0.0,
                            "minReroutePercentage": 0.0,
                            "name": "str",
                            "reroutePercentage": 0.0,
                        }
                    ]
                },
                "ftpsState": "str",
                "functionAppScaleLimit": 0,
                "functionsRuntimeScaleMonitoringEnabled": bool,
                "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                "healthCheckPath": "str",
                "http20Enabled": True,
                "http20ProxyFlag": 0,
                "httpLoggingEnabled": bool,
                "id": "str",
                "ipSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "ipSecurityRestrictionsDefaultAction": "str",
                "javaContainer": "str",
                "javaContainerVersion": "str",
                "javaVersion": "str",
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                "linuxFxVersion": "str",
                "loadBalancing": "str",
                "localMySqlEnabled": False,
                "logsDirectorySizeLimit": 0,
                "machineKey": {
                    "decryption": "str",
                    "decryptionKey": "str",
                    "validation": "str",
                    "validationKey": "str",
                },
                "managedPipelineMode": "str",
                "managedServiceIdentityId": 0,
                "metadata": [{"name": "str", "value": "str"}],
                "minTlsCipherSuite": "str",
                "minTlsVersion": "str",
                "minimumElasticInstanceCount": 0,
                "name": "str",
                "netFrameworkVersion": "v4.6",
                "nodeVersion": "str",
                "numberOfWorkers": 0,
                "phpVersion": "str",
                "powerShellVersion": "str",
                "preWarmedInstanceCount": 0,
                "publicNetworkAccess": "str",
                "publishingUsername": "str",
                "push": {
                    "dynamicTagsJson": "str",
                    "id": "str",
                    "isPushEnabled": bool,
                    "kind": "str",
                    "name": "str",
                    "tagWhitelistJson": "str",
                    "tagsRequiringAuth": "str",
                    "type": "str",
                },
                "pythonVersion": "str",
                "remoteDebuggingEnabled": bool,
                "remoteDebuggingVersion": "str",
                "requestTracingEnabled": bool,
                "requestTracingExpirationTime": "2020-02-20 00:00:00",
                "scmIpSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "scmIpSecurityRestrictionsDefaultAction": "str",
                "scmIpSecurityRestrictionsUseMain": bool,
                "scmMinTlsVersion": "str",
                "scmType": "str",
                "tracingOptions": "str",
                "type": "str",
                "use32BitWorkerProcess": bool,
                "virtualApplications": [
                    {
                        "physicalPath": "str",
                        "preloadEnabled": bool,
                        "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                        "virtualPath": "str",
                    }
                ],
                "vnetName": "str",
                "vnetPrivatePortsCount": 0,
                "vnetRouteAllEnabled": bool,
                "webSocketsEnabled": bool,
                "websiteTimeZone": "str",
                "windowsFxVersion": "str",
                "xManagedServiceIdentityId": 0,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_configuration_snapshot_info(self, resource_group):
        response = self.client.web_apps.list_configuration_snapshot_info(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_configuration_snapshot(self, resource_group):
        response = self.client.web_apps.get_configuration_snapshot(
            resource_group_name=resource_group.name,
            name="str",
            snapshot_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_recover_site_configuration_snapshot(self, resource_group):
        response = self.client.web_apps.recover_site_configuration_snapshot(
            resource_group_name=resource_group.name,
            name="str",
            snapshot_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_web_site_container_logs(self, resource_group):
        response = self.client.web_apps.get_web_site_container_logs(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_container_logs_zip(self, resource_group):
        response = self.client.web_apps.get_container_logs_zip(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_continuous_web_jobs(self, resource_group):
        response = self.client.web_apps.list_continuous_web_jobs(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_continuous_web_job(self, resource_group):
        response = self.client.web_apps.get_continuous_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_continuous_web_job(self, resource_group):
        response = self.client.web_apps.delete_continuous_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start_continuous_web_job(self, resource_group):
        response = self.client.web_apps.start_continuous_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_continuous_web_job(self, resource_group):
        response = self.client.web_apps.stop_continuous_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_production_site_deployment_statuses(self, resource_group):
        response = self.client.web_apps.list_production_site_deployment_statuses(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_get_production_site_deployment_status(self, resource_group):
        response = self.client.web_apps.begin_get_production_site_deployment_status(
            resource_group_name=resource_group.name,
            name="str",
            deployment_status_id="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_deployments(self, resource_group):
        response = self.client.web_apps.list_deployments(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_deployment(self, resource_group):
        response = self.client.web_apps.get_deployment(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_deployment(self, resource_group):
        response = self.client.web_apps.create_deployment(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            deployment={
                "active": bool,
                "author": "str",
                "author_email": "str",
                "deployer": "str",
                "details": "str",
                "end_time": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "message": "str",
                "name": "str",
                "start_time": "2020-02-20 00:00:00",
                "status": 0,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_deployment(self, resource_group):
        response = self.client.web_apps.delete_deployment(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_deployment_log(self, resource_group):
        response = self.client.web_apps.list_deployment_log(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_discover_backup(self, resource_group):
        response = self.client.web_apps.discover_backup(
            resource_group_name=resource_group.name,
            name="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_domain_ownership_identifiers(self, resource_group):
        response = self.client.web_apps.list_domain_ownership_identifiers(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_domain_ownership_identifier(self, resource_group):
        response = self.client.web_apps.get_domain_ownership_identifier(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_domain_ownership_identifier(self, resource_group):
        response = self.client.web_apps.create_or_update_domain_ownership_identifier(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            domain_ownership_identifier={"id": "str", "kind": "str", "name": "str", "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_domain_ownership_identifier(self, resource_group):
        response = self.client.web_apps.delete_domain_ownership_identifier(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_domain_ownership_identifier(self, resource_group):
        response = self.client.web_apps.update_domain_ownership_identifier(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            domain_ownership_identifier={"id": "str", "kind": "str", "name": "str", "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ms_deploy_status(self, resource_group):
        response = self.client.web_apps.get_ms_deploy_status(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_ms_deploy_operation(self, resource_group):
        response = self.client.web_apps.begin_create_ms_deploy_operation(
            resource_group_name=resource_group.name,
            name="str",
            ms_deploy={
                "appOffline": bool,
                "connectionString": "str",
                "dbType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "packageUri": "str",
                "setParameters": {"str": "str"},
                "setParametersXmlFileUri": "str",
                "skipAppData": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ms_deploy_log(self, resource_group):
        response = self.client.web_apps.get_ms_deploy_log(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_one_deploy_status(self, resource_group):
        response = self.client.web_apps.get_one_deploy_status(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_one_deploy_operation(self, resource_group):
        response = self.client.web_apps.create_one_deploy_operation(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_functions(self, resource_group):
        response = self.client.web_apps.list_functions(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_functions_admin_token(self, resource_group):
        response = self.client.web_apps.get_functions_admin_token(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_function(self, resource_group):
        response = self.client.web_apps.get_function(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_function(self, resource_group):
        response = self.client.web_apps.begin_create_function(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            function_envelope={
                "config": {},
                "config_href": "str",
                "files": {"str": "str"},
                "function_app_id": "str",
                "href": "str",
                "id": "str",
                "invoke_url_template": "str",
                "isDisabled": bool,
                "kind": "str",
                "language": "str",
                "name": "str",
                "script_href": "str",
                "script_root_path_href": "str",
                "secrets_file_href": "str",
                "test_data": "str",
                "test_data_href": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_function(self, resource_group):
        response = self.client.web_apps.delete_function(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_function_secret(self, resource_group):
        response = self.client.web_apps.create_or_update_function_secret(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            key_name="str",
            key={"name": "str", "value": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_function_secret(self, resource_group):
        response = self.client.web_apps.delete_function_secret(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            key_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_function_keys(self, resource_group):
        response = self.client.web_apps.list_function_keys(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_function_secrets(self, resource_group):
        response = self.client.web_apps.list_function_secrets(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_host_keys(self, resource_group):
        response = self.client.web_apps.list_host_keys(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_sync_status(self, resource_group):
        response = self.client.web_apps.list_sync_status(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_functions(self, resource_group):
        response = self.client.web_apps.sync_functions(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_host_secret(self, resource_group):
        response = self.client.web_apps.create_or_update_host_secret(
            resource_group_name=resource_group.name,
            name="str",
            key_type="str",
            key_name="str",
            key={"name": "str", "value": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_host_secret(self, resource_group):
        response = self.client.web_apps.delete_host_secret(
            resource_group_name=resource_group.name,
            name="str",
            key_type="str",
            key_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_host_name_bindings(self, resource_group):
        response = self.client.web_apps.list_host_name_bindings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_host_name_binding(self, resource_group):
        response = self.client.web_apps.get_host_name_binding(
            resource_group_name=resource_group.name,
            name="str",
            host_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_host_name_binding(self, resource_group):
        response = self.client.web_apps.create_or_update_host_name_binding(
            resource_group_name=resource_group.name,
            name="str",
            host_name="str",
            host_name_binding={
                "azureResourceName": "str",
                "azureResourceType": "str",
                "customHostNameDnsRecordType": "str",
                "domainId": "str",
                "hostNameType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "siteName": "str",
                "sslState": "str",
                "thumbprint": "str",
                "type": "str",
                "virtualIP": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_host_name_binding(self, resource_group):
        response = self.client.web_apps.delete_host_name_binding(
            resource_group_name=resource_group.name,
            name="str",
            host_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_hybrid_connection(self, resource_group):
        response = self.client.web_apps.get_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_hybrid_connection(self, resource_group):
        response = self.client.web_apps.create_or_update_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            connection_envelope={
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "relayArmUri": "str",
                "relayName": "str",
                "sendKeyName": "str",
                "sendKeyValue": "str",
                "serviceBusNamespace": "str",
                "serviceBusSuffix": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_hybrid_connection(self, resource_group):
        response = self.client.web_apps.delete_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_hybrid_connection(self, resource_group):
        response = self.client.web_apps.update_hybrid_connection(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            connection_envelope={
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "relayArmUri": "str",
                "relayName": "str",
                "sendKeyName": "str",
                "sendKeyValue": "str",
                "serviceBusNamespace": "str",
                "serviceBusSuffix": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_hybrid_connections(self, resource_group):
        response = self.client.web_apps.list_hybrid_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_relay_service_connections(self, resource_group):
        response = self.client.web_apps.list_relay_service_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_relay_service_connection(self, resource_group):
        response = self.client.web_apps.get_relay_service_connection(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_relay_service_connection(self, resource_group):
        response = self.client.web_apps.create_or_update_relay_service_connection(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            connection_envelope={
                "biztalkUri": "str",
                "entityConnectionString": "str",
                "entityName": "str",
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "resourceConnectionString": "str",
                "resourceType": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_relay_service_connection(self, resource_group):
        response = self.client.web_apps.delete_relay_service_connection(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_relay_service_connection(self, resource_group):
        response = self.client.web_apps.update_relay_service_connection(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            connection_envelope={
                "biztalkUri": "str",
                "entityConnectionString": "str",
                "entityName": "str",
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "resourceConnectionString": "str",
                "resourceType": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_identifiers(self, resource_group):
        response = self.client.web_apps.list_instance_identifiers(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_info(self, resource_group):
        response = self.client.web_apps.get_instance_info(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_ms_deploy_status(self, resource_group):
        response = self.client.web_apps.get_instance_ms_deploy_status(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_instance_ms_deploy_operation(self, resource_group):
        response = self.client.web_apps.begin_create_instance_ms_deploy_operation(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            ms_deploy={
                "appOffline": bool,
                "connectionString": "str",
                "dbType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "packageUri": "str",
                "setParameters": {"str": "str"},
                "setParametersXmlFileUri": "str",
                "skipAppData": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_ms_deploy_log(self, resource_group):
        response = self.client.web_apps.get_instance_ms_deploy_log(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_processes(self, resource_group):
        response = self.client.web_apps.list_instance_processes(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process(self, resource_group):
        response = self.client.web_apps.get_instance_process(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_instance_process(self, resource_group):
        response = self.client.web_apps.delete_instance_process(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process_dump(self, resource_group):
        response = self.client.web_apps.get_instance_process_dump(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_process_modules(self, resource_group):
        response = self.client.web_apps.list_instance_process_modules(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process_module(self, resource_group):
        response = self.client.web_apps.get_instance_process_module(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            base_address="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_process_threads(self, resource_group):
        response = self.client.web_apps.list_instance_process_threads(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_is_cloneable(self, resource_group):
        response = self.client.web_apps.is_cloneable(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_backups(self, resource_group):
        response = self.client.web_apps.list_site_backups(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_sync_function_triggers(self, resource_group):
        response = self.client.web_apps.list_sync_function_triggers(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_machine_key(self, resource_group):
        response = self.client.web_apps.update_machine_key(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_migrate_storage(self, resource_group):
        response = self.client.web_apps.begin_migrate_storage(
            subscription_name="str",
            resource_group_name=resource_group.name,
            name="str",
            migration_options={
                "azurefilesConnectionString": "str",
                "azurefilesShare": "str",
                "blockWriteAccessToSite": False,
                "id": "str",
                "kind": "str",
                "name": "str",
                "switchSiteAfterMigration": False,
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_migrate_my_sql(self, resource_group):
        response = self.client.web_apps.begin_migrate_my_sql(
            resource_group_name=resource_group.name,
            name="str",
            migration_request_envelope={
                "connectionString": "str",
                "id": "str",
                "kind": "str",
                "migrationType": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_migrate_my_sql_status(self, resource_group):
        response = self.client.web_apps.get_migrate_my_sql_status(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_swift_virtual_network_connection(self, resource_group):
        response = self.client.web_apps.get_swift_virtual_network_connection(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_swift_virtual_network_connection_with_check(self, resource_group):
        response = self.client.web_apps.create_or_update_swift_virtual_network_connection_with_check(
            resource_group_name=resource_group.name,
            name="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "subnetResourceId": "str",
                "swiftSupported": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_swift_virtual_network(self, resource_group):
        response = self.client.web_apps.delete_swift_virtual_network(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_swift_virtual_network_connection_with_check(self, resource_group):
        response = self.client.web_apps.update_swift_virtual_network_connection_with_check(
            resource_group_name=resource_group.name,
            name="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "subnetResourceId": "str",
                "swiftSupported": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_network_features(self, resource_group):
        response = self.client.web_apps.list_network_features(
            resource_group_name=resource_group.name,
            name="str",
            view="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_trace_operation(self, resource_group):
        response = self.client.web_apps.get_network_trace_operation(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start_web_site_network_trace(self, resource_group):
        response = self.client.web_apps.start_web_site_network_trace(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_start_web_site_network_trace_operation(self, resource_group):
        response = self.client.web_apps.begin_start_web_site_network_trace_operation(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_web_site_network_trace(self, resource_group):
        response = self.client.web_apps.stop_web_site_network_trace(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_traces(self, resource_group):
        response = self.client.web_apps.get_network_traces(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_trace_operation_v2(self, resource_group):
        response = self.client.web_apps.get_network_trace_operation_v2(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_traces_v2(self, resource_group):
        response = self.client.web_apps.get_network_traces_v2(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_generate_new_site_publishing_password(self, resource_group):
        response = self.client.web_apps.generate_new_site_publishing_password(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_perf_mon_counters(self, resource_group):
        response = self.client.web_apps.list_perf_mon_counters(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_php_error_log_flag(self, resource_group):
        response = self.client.web_apps.get_site_php_error_log_flag(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_premier_add_ons(self, resource_group):
        response = self.client.web_apps.list_premier_add_ons(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_premier_add_on(self, resource_group):
        response = self.client.web_apps.get_premier_add_on(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_add_premier_add_on(self, resource_group):
        response = self.client.web_apps.add_premier_add_on(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            premier_add_on={
                "location": "str",
                "id": "str",
                "kind": "str",
                "marketplaceOffer": "str",
                "marketplacePublisher": "str",
                "name": "str",
                "product": "str",
                "sku": "str",
                "tags": {"str": "str"},
                "type": "str",
                "vendor": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_premier_add_on(self, resource_group):
        response = self.client.web_apps.delete_premier_add_on(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_premier_add_on(self, resource_group):
        response = self.client.web_apps.update_premier_add_on(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            premier_add_on={
                "id": "str",
                "kind": "str",
                "marketplaceOffer": "str",
                "marketplacePublisher": "str",
                "name": "str",
                "product": "str",
                "sku": "str",
                "type": "str",
                "vendor": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_access(self, resource_group):
        response = self.client.web_apps.get_private_access(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_put_private_access_vnet(self, resource_group):
        response = self.client.web_apps.put_private_access_vnet(
            resource_group_name=resource_group.name,
            name="str",
            access={
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "virtualNetworks": [
                    {"key": 0, "name": "str", "resourceId": "str", "subnets": [{"key": 0, "name": "str"}]}
                ],
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_endpoint_connection_list(self, resource_group):
        response = self.client.web_apps.get_private_endpoint_connection_list(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_endpoint_connection(self, resource_group):
        response = self.client.web_apps.get_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_approve_or_reject_private_endpoint_connection(self, resource_group):
        response = self.client.web_apps.begin_approve_or_reject_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            private_endpoint_wrapper={
                "id": "str",
                "ipAddresses": ["str"],
                "kind": "str",
                "name": "str",
                "privateEndpoint": {"id": "str"},
                "privateLinkServiceConnectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_delete_private_endpoint_connection(self, resource_group):
        response = self.client.web_apps.begin_delete_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_link_resources(self, resource_group):
        response = self.client.web_apps.get_private_link_resources(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_processes(self, resource_group):
        response = self.client.web_apps.list_processes(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process(self, resource_group):
        response = self.client.web_apps.get_process(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_process(self, resource_group):
        response = self.client.web_apps.delete_process(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process_dump(self, resource_group):
        response = self.client.web_apps.get_process_dump(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_process_modules(self, resource_group):
        response = self.client.web_apps.list_process_modules(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process_module(self, resource_group):
        response = self.client.web_apps.get_process_module(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            base_address="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_process_threads(self, resource_group):
        response = self.client.web_apps.list_process_threads(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_public_certificates(self, resource_group):
        response = self.client.web_apps.list_public_certificates(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_public_certificate(self, resource_group):
        response = self.client.web_apps.get_public_certificate(
            resource_group_name=resource_group.name,
            name="str",
            public_certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_public_certificate(self, resource_group):
        response = self.client.web_apps.create_or_update_public_certificate(
            resource_group_name=resource_group.name,
            name="str",
            public_certificate_name="str",
            public_certificate={
                "blob": bytes("bytes", encoding="utf-8"),
                "id": "str",
                "kind": "str",
                "name": "str",
                "publicCertificateLocation": "str",
                "thumbprint": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_public_certificate(self, resource_group):
        response = self.client.web_apps.delete_public_certificate(
            resource_group_name=resource_group.name,
            name="str",
            public_certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_publishing_profile_xml_with_secrets(self, resource_group):
        response = self.client.web_apps.list_publishing_profile_xml_with_secrets(
            resource_group_name=resource_group.name,
            name="str",
            publishing_profile_options={"format": "str", "includeDisasterRecoveryEndpoints": bool},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_reset_production_slot_config(self, resource_group):
        response = self.client.web_apps.reset_production_slot_config(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_restart(self, resource_group):
        response = self.client.web_apps.restart(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_from_backup_blob(self, resource_group):
        response = self.client.web_apps.begin_restore_from_backup_blob(
            resource_group_name=resource_group.name,
            name="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_from_deleted_app(self, resource_group):
        response = self.client.web_apps.begin_restore_from_deleted_app(
            resource_group_name=resource_group.name,
            name="str",
            restore_request={
                "deletedSiteId": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "recoverConfiguration": bool,
                "snapshotTime": "str",
                "type": "str",
                "useDRSecondary": bool,
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_snapshot(self, resource_group):
        response = self.client.web_apps.begin_restore_snapshot(
            resource_group_name=resource_group.name,
            name="str",
            restore_request={
                "id": "str",
                "ignoreConflictingHostNames": bool,
                "kind": "str",
                "name": "str",
                "overwrite": bool,
                "recoverConfiguration": bool,
                "recoverySource": {"id": "str", "location": "str"},
                "snapshotTime": "str",
                "type": "str",
                "useDRSecondary": bool,
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_containers(self, resource_group):
        response = self.client.web_apps.list_site_containers(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_container(self, resource_group):
        response = self.client.web_apps.get_site_container(
            resource_group_name=resource_group.name,
            name="str",
            container_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_site_container(self, resource_group):
        response = self.client.web_apps.create_or_update_site_container(
            resource_group_name=resource_group.name,
            name="str",
            container_name="str",
            request={
                "authType": "str",
                "createdTime": "2020-02-20 00:00:00",
                "environmentVariables": [{"name": "str", "value": "str"}],
                "id": "str",
                "image": "str",
                "inheritAppSettingsAndConnectionStrings": bool,
                "isMain": bool,
                "kind": "str",
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "passwordSecret": "str",
                "startUpCommand": "str",
                "targetPort": "str",
                "type": "str",
                "userManagedIdentityClientId": "str",
                "userName": "str",
                "volumeMounts": [
                    {"containerMountPath": "str", "volumeSubPath": "str", "data": "str", "readOnly": bool}
                ],
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_site_container(self, resource_group):
        response = self.client.web_apps.delete_site_container(
            resource_group_name=resource_group.name,
            name="str",
            container_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_extensions(self, resource_group):
        response = self.client.web_apps.list_site_extensions(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_extension(self, resource_group):
        response = self.client.web_apps.get_site_extension(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_install_site_extension(self, resource_group):
        response = self.client.web_apps.begin_install_site_extension(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_site_extension(self, resource_group):
        response = self.client.web_apps.delete_site_extension(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_slots(self, resource_group):
        response = self.client.web_apps.list_slots(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_slot(self, resource_group):
        response = self.client.web_apps.get_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_or_update_slot(self, resource_group):
        response = self.client.web_apps.begin_create_or_update_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_envelope={
                "location": "str",
                "autoGeneratedDomainNameLabelScope": "str",
                "availabilityState": "str",
                "clientAffinityEnabled": bool,
                "clientAffinityPartitioningEnabled": bool,
                "clientAffinityProxyEnabled": bool,
                "clientCertEnabled": bool,
                "clientCertExclusionPaths": "str",
                "clientCertMode": "str",
                "cloningInfo": {
                    "sourceWebAppId": "str",
                    "appSettingsOverrides": {"str": "str"},
                    "cloneCustomHostNames": bool,
                    "cloneSourceControl": bool,
                    "configureLoadBalancing": bool,
                    "correlationId": "str",
                    "hostingEnvironment": "str",
                    "overwrite": bool,
                    "sourceWebAppLocation": "str",
                    "trafficManagerProfileId": "str",
                    "trafficManagerProfileName": "str",
                },
                "containerSize": 0,
                "customDomainVerificationId": "str",
                "dailyMemoryTimeQuota": 0,
                "daprConfig": {
                    "appId": "str",
                    "appPort": 0,
                    "enableApiLogging": bool,
                    "enabled": False,
                    "httpMaxRequestSize": 0,
                    "httpReadBufferSize": 0,
                    "logLevel": "str",
                },
                "defaultHostName": "str",
                "dnsConfiguration": {
                    "dnsAltServer": "str",
                    "dnsLegacySortOrder": bool,
                    "dnsMaxCacheTimeout": 0,
                    "dnsRetryAttemptCount": 0,
                    "dnsRetryAttemptTimeout": 0,
                    "dnsServers": ["str"],
                },
                "enabled": bool,
                "enabledHostNames": ["str"],
                "endToEndEncryptionEnabled": bool,
                "extendedLocation": {"name": "str", "type": "str"},
                "functionAppConfig": {
                    "deployment": {
                        "storage": {
                            "authentication": {
                                "storageAccountConnectionStringName": "str",
                                "type": "str",
                                "userAssignedIdentityResourceId": "str",
                            },
                            "type": "str",
                            "value": "str",
                        }
                    },
                    "runtime": {"name": "str", "version": "str"},
                    "scaleAndConcurrency": {
                        "alwaysReady": [{"instanceCount": 0, "name": "str"}],
                        "instanceMemoryMB": 0,
                        "maximumInstanceCount": 0,
                        "triggers": {"http": {"perInstanceConcurrency": 0}},
                    },
                },
                "hostNameSslStates": [
                    {
                        "hostType": "str",
                        "name": "str",
                        "sslState": "str",
                        "thumbprint": "str",
                        "toUpdate": bool,
                        "virtualIP": "str",
                    }
                ],
                "hostNames": ["str"],
                "hostNamesDisabled": bool,
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "httpsOnly": bool,
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inProgressOperationId": "str",
                "ipMode": "str",
                "isDefaultContainer": bool,
                "isXenon": False,
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "lastModifiedTimeUtc": "2020-02-20 00:00:00",
                "managedEnvironmentId": "str",
                "maxNumberOfWorkers": 0,
                "name": "str",
                "outboundIpAddresses": "str",
                "outboundVnetRouting": {
                    "allTraffic": bool,
                    "applicationTraffic": bool,
                    "backupRestoreTraffic": bool,
                    "contentShareTraffic": bool,
                    "imagePullTraffic": bool,
                },
                "possibleOutboundIpAddresses": "str",
                "publicNetworkAccess": "str",
                "redundancyMode": "str",
                "repositorySiteName": "str",
                "reserved": False,
                "resourceConfig": {"cpu": 0.0, "memory": "str"},
                "resourceGroup": "str",
                "scmSiteAlsoStopped": False,
                "serverFarmId": "str",
                "siteConfig": {
                    "acrUseManagedIdentityCreds": bool,
                    "acrUserManagedIdentityID": "str",
                    "alwaysOn": bool,
                    "apiDefinition": {"url": "str"},
                    "apiManagementConfig": {"id": "str"},
                    "appCommandLine": "str",
                    "appSettings": [{"name": "str", "value": "str"}],
                    "autoHealEnabled": bool,
                    "autoHealRules": {
                        "actions": {
                            "actionType": "str",
                            "customAction": {"exe": "str", "parameters": "str"},
                            "minProcessExecutionTime": "str",
                        },
                        "triggers": {
                            "privateBytesInKB": 0,
                            "requests": {"count": 0, "timeInterval": "str"},
                            "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                            "slowRequestsWithPath": [
                                {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                            ],
                            "statusCodes": [
                                {
                                    "count": 0,
                                    "path": "str",
                                    "status": 0,
                                    "subStatus": 0,
                                    "timeInterval": "str",
                                    "win32Status": 0,
                                }
                            ],
                            "statusCodesRange": [
                                {"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}
                            ],
                        },
                    },
                    "autoSwapSlotName": "str",
                    "azureStorageAccounts": {
                        "str": {
                            "accessKey": "str",
                            "accountName": "str",
                            "mountPath": "str",
                            "protocol": "str",
                            "shareName": "str",
                            "state": "str",
                            "type": "str",
                        }
                    },
                    "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                    "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                    "defaultDocuments": ["str"],
                    "detailedErrorLoggingEnabled": bool,
                    "documentRoot": "str",
                    "elasticWebAppScaleLimit": 0,
                    "experiments": {
                        "rampUpRules": [
                            {
                                "actionHostName": "str",
                                "changeDecisionCallbackUrl": "str",
                                "changeIntervalInMinutes": 0,
                                "changeStep": 0.0,
                                "maxReroutePercentage": 0.0,
                                "minReroutePercentage": 0.0,
                                "name": "str",
                                "reroutePercentage": 0.0,
                            }
                        ]
                    },
                    "ftpsState": "str",
                    "functionAppScaleLimit": 0,
                    "functionsRuntimeScaleMonitoringEnabled": bool,
                    "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                    "healthCheckPath": "str",
                    "http20Enabled": True,
                    "http20ProxyFlag": 0,
                    "httpLoggingEnabled": bool,
                    "ipSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "ipSecurityRestrictionsDefaultAction": "str",
                    "javaContainer": "str",
                    "javaContainerVersion": "str",
                    "javaVersion": "str",
                    "keyVaultReferenceIdentity": "str",
                    "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                    "linuxFxVersion": "str",
                    "loadBalancing": "str",
                    "localMySqlEnabled": False,
                    "logsDirectorySizeLimit": 0,
                    "machineKey": {
                        "decryption": "str",
                        "decryptionKey": "str",
                        "validation": "str",
                        "validationKey": "str",
                    },
                    "managedPipelineMode": "str",
                    "managedServiceIdentityId": 0,
                    "metadata": [{"name": "str", "value": "str"}],
                    "minTlsCipherSuite": "str",
                    "minTlsVersion": "str",
                    "minimumElasticInstanceCount": 0,
                    "netFrameworkVersion": "v4.6",
                    "nodeVersion": "str",
                    "numberOfWorkers": 0,
                    "phpVersion": "str",
                    "powerShellVersion": "str",
                    "preWarmedInstanceCount": 0,
                    "publicNetworkAccess": "str",
                    "publishingUsername": "str",
                    "push": {
                        "dynamicTagsJson": "str",
                        "id": "str",
                        "isPushEnabled": bool,
                        "kind": "str",
                        "name": "str",
                        "tagWhitelistJson": "str",
                        "tagsRequiringAuth": "str",
                        "type": "str",
                    },
                    "pythonVersion": "str",
                    "remoteDebuggingEnabled": bool,
                    "remoteDebuggingVersion": "str",
                    "requestTracingEnabled": bool,
                    "requestTracingExpirationTime": "2020-02-20 00:00:00",
                    "scmIpSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "scmIpSecurityRestrictionsDefaultAction": "str",
                    "scmIpSecurityRestrictionsUseMain": bool,
                    "scmMinTlsVersion": "str",
                    "scmType": "str",
                    "tracingOptions": "str",
                    "use32BitWorkerProcess": bool,
                    "virtualApplications": [
                        {
                            "physicalPath": "str",
                            "preloadEnabled": bool,
                            "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                            "virtualPath": "str",
                        }
                    ],
                    "vnetName": "str",
                    "vnetPrivatePortsCount": 0,
                    "vnetRouteAllEnabled": bool,
                    "webSocketsEnabled": bool,
                    "websiteTimeZone": "str",
                    "windowsFxVersion": "str",
                    "xManagedServiceIdentityId": 0,
                },
                "sku": "str",
                "slotSwapStatus": {
                    "destinationSlotName": "str",
                    "sourceSlotName": "str",
                    "timestampUtc": "2020-02-20 00:00:00",
                },
                "sshEnabled": bool,
                "state": "str",
                "storageAccountRequired": bool,
                "suspendedTill": "2020-02-20 00:00:00",
                "tags": {"str": "str"},
                "targetSwapSlot": "str",
                "trafficManagerHostNames": ["str"],
                "type": "str",
                "usageState": "str",
                "virtualNetworkSubnetId": "str",
                "workloadProfileName": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_slot(self, resource_group):
        response = self.client.web_apps.delete_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_slot(self, resource_group):
        response = self.client.web_apps.update_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_envelope={
                "availabilityState": "str",
                "clientAffinityEnabled": bool,
                "clientAffinityProxyEnabled": bool,
                "clientCertEnabled": bool,
                "clientCertExclusionPaths": "str",
                "clientCertMode": "str",
                "cloningInfo": {
                    "sourceWebAppId": "str",
                    "appSettingsOverrides": {"str": "str"},
                    "cloneCustomHostNames": bool,
                    "cloneSourceControl": bool,
                    "configureLoadBalancing": bool,
                    "correlationId": "str",
                    "hostingEnvironment": "str",
                    "overwrite": bool,
                    "sourceWebAppLocation": "str",
                    "trafficManagerProfileId": "str",
                    "trafficManagerProfileName": "str",
                },
                "containerSize": 0,
                "customDomainVerificationId": "str",
                "dailyMemoryTimeQuota": 0,
                "defaultHostName": "str",
                "dnsConfiguration": {
                    "dnsAltServer": "str",
                    "dnsLegacySortOrder": bool,
                    "dnsMaxCacheTimeout": 0,
                    "dnsRetryAttemptCount": 0,
                    "dnsRetryAttemptTimeout": 0,
                    "dnsServers": ["str"],
                },
                "enabled": bool,
                "enabledHostNames": ["str"],
                "hostNameSslStates": [
                    {
                        "hostType": "str",
                        "name": "str",
                        "sslState": "str",
                        "thumbprint": "str",
                        "toUpdate": bool,
                        "virtualIP": "str",
                    }
                ],
                "hostNames": ["str"],
                "hostNamesDisabled": bool,
                "hostingEnvironmentProfile": {"id": "str", "name": "str", "type": "str"},
                "httpsOnly": bool,
                "hyperV": False,
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inProgressOperationId": "str",
                "isDefaultContainer": bool,
                "isXenon": False,
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "lastModifiedTimeUtc": "2020-02-20 00:00:00",
                "maxNumberOfWorkers": 0,
                "name": "str",
                "outboundIpAddresses": "str",
                "possibleOutboundIpAddresses": "str",
                "redundancyMode": "str",
                "repositorySiteName": "str",
                "reserved": False,
                "resourceGroup": "str",
                "scmSiteAlsoStopped": False,
                "serverFarmId": "str",
                "siteConfig": {
                    "acrUseManagedIdentityCreds": bool,
                    "acrUserManagedIdentityID": "str",
                    "alwaysOn": bool,
                    "apiDefinition": {"url": "str"},
                    "apiManagementConfig": {"id": "str"},
                    "appCommandLine": "str",
                    "appSettings": [{"name": "str", "value": "str"}],
                    "autoHealEnabled": bool,
                    "autoHealRules": {
                        "actions": {
                            "actionType": "str",
                            "customAction": {"exe": "str", "parameters": "str"},
                            "minProcessExecutionTime": "str",
                        },
                        "triggers": {
                            "privateBytesInKB": 0,
                            "requests": {"count": 0, "timeInterval": "str"},
                            "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                            "slowRequestsWithPath": [
                                {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                            ],
                            "statusCodes": [
                                {
                                    "count": 0,
                                    "path": "str",
                                    "status": 0,
                                    "subStatus": 0,
                                    "timeInterval": "str",
                                    "win32Status": 0,
                                }
                            ],
                            "statusCodesRange": [
                                {"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}
                            ],
                        },
                    },
                    "autoSwapSlotName": "str",
                    "azureStorageAccounts": {
                        "str": {
                            "accessKey": "str",
                            "accountName": "str",
                            "mountPath": "str",
                            "protocol": "str",
                            "shareName": "str",
                            "state": "str",
                            "type": "str",
                        }
                    },
                    "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                    "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                    "defaultDocuments": ["str"],
                    "detailedErrorLoggingEnabled": bool,
                    "documentRoot": "str",
                    "elasticWebAppScaleLimit": 0,
                    "experiments": {
                        "rampUpRules": [
                            {
                                "actionHostName": "str",
                                "changeDecisionCallbackUrl": "str",
                                "changeIntervalInMinutes": 0,
                                "changeStep": 0.0,
                                "maxReroutePercentage": 0.0,
                                "minReroutePercentage": 0.0,
                                "name": "str",
                                "reroutePercentage": 0.0,
                            }
                        ]
                    },
                    "ftpsState": "str",
                    "functionAppScaleLimit": 0,
                    "functionsRuntimeScaleMonitoringEnabled": bool,
                    "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                    "healthCheckPath": "str",
                    "http20Enabled": True,
                    "http20ProxyFlag": 0,
                    "httpLoggingEnabled": bool,
                    "ipSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "ipSecurityRestrictionsDefaultAction": "str",
                    "javaContainer": "str",
                    "javaContainerVersion": "str",
                    "javaVersion": "str",
                    "keyVaultReferenceIdentity": "str",
                    "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                    "linuxFxVersion": "str",
                    "loadBalancing": "str",
                    "localMySqlEnabled": False,
                    "logsDirectorySizeLimit": 0,
                    "machineKey": {
                        "decryption": "str",
                        "decryptionKey": "str",
                        "validation": "str",
                        "validationKey": "str",
                    },
                    "managedPipelineMode": "str",
                    "managedServiceIdentityId": 0,
                    "metadata": [{"name": "str", "value": "str"}],
                    "minTlsCipherSuite": "str",
                    "minTlsVersion": "str",
                    "minimumElasticInstanceCount": 0,
                    "netFrameworkVersion": "v4.6",
                    "nodeVersion": "str",
                    "numberOfWorkers": 0,
                    "phpVersion": "str",
                    "powerShellVersion": "str",
                    "preWarmedInstanceCount": 0,
                    "publicNetworkAccess": "str",
                    "publishingUsername": "str",
                    "push": {
                        "dynamicTagsJson": "str",
                        "id": "str",
                        "isPushEnabled": bool,
                        "kind": "str",
                        "name": "str",
                        "tagWhitelistJson": "str",
                        "tagsRequiringAuth": "str",
                        "type": "str",
                    },
                    "pythonVersion": "str",
                    "remoteDebuggingEnabled": bool,
                    "remoteDebuggingVersion": "str",
                    "requestTracingEnabled": bool,
                    "requestTracingExpirationTime": "2020-02-20 00:00:00",
                    "scmIpSecurityRestrictions": [
                        {
                            "action": "str",
                            "description": "str",
                            "headers": {"str": ["str"]},
                            "ipAddress": "str",
                            "name": "str",
                            "priority": 0,
                            "subnetMask": "str",
                            "subnetTrafficTag": 0,
                            "tag": "str",
                            "vnetSubnetResourceId": "str",
                            "vnetTrafficTag": 0,
                        }
                    ],
                    "scmIpSecurityRestrictionsDefaultAction": "str",
                    "scmIpSecurityRestrictionsUseMain": bool,
                    "scmMinTlsVersion": "str",
                    "scmType": "str",
                    "tracingOptions": "str",
                    "use32BitWorkerProcess": bool,
                    "virtualApplications": [
                        {
                            "physicalPath": "str",
                            "preloadEnabled": bool,
                            "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                            "virtualPath": "str",
                        }
                    ],
                    "vnetName": "str",
                    "vnetPrivatePortsCount": 0,
                    "vnetRouteAllEnabled": bool,
                    "webSocketsEnabled": bool,
                    "websiteTimeZone": "str",
                    "windowsFxVersion": "str",
                    "xManagedServiceIdentityId": 0,
                },
                "slotSwapStatus": {
                    "destinationSlotName": "str",
                    "sourceSlotName": "str",
                    "timestampUtc": "2020-02-20 00:00:00",
                },
                "state": "str",
                "storageAccountRequired": bool,
                "suspendedTill": "2020-02-20 00:00:00",
                "targetSwapSlot": "str",
                "trafficManagerHostNames": ["str"],
                "type": "str",
                "usageState": "str",
                "virtualNetworkSubnetId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_analyze_custom_hostname_slot(self, resource_group):
        response = self.client.web_apps.analyze_custom_hostname_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_apply_slot_configuration_slot(self, resource_group):
        response = self.client.web_apps.apply_slot_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_backup_slot(self, resource_group):
        response = self.client.web_apps.backup_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_backups_slot(self, resource_group):
        response = self.client.web_apps.list_backups_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_backup_status_slot(self, resource_group):
        response = self.client.web_apps.get_backup_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_backup_slot(self, resource_group):
        response = self.client.web_apps.delete_backup_slot(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_backup_status_secrets_slot(self, resource_group):
        response = self.client.web_apps.list_backup_status_secrets_slot(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            slot="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_slot(self, resource_group):
        response = self.client.web_apps.begin_restore_slot(
            resource_group_name=resource_group.name,
            name="str",
            backup_id="str",
            slot="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_basic_publishing_credentials_policies_slot(self, resource_group):
        response = self.client.web_apps.list_basic_publishing_credentials_policies_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ftp_allowed_slot(self, resource_group):
        response = self.client.web_apps.get_ftp_allowed_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_ftp_allowed_slot(self, resource_group):
        response = self.client.web_apps.update_ftp_allowed_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            csm_publishing_access_policies_entity={
                "allow": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_scm_allowed_slot(self, resource_group):
        response = self.client.web_apps.get_scm_allowed_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_scm_allowed_slot(self, resource_group):
        response = self.client.web_apps.update_scm_allowed_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            csm_publishing_access_policies_entity={
                "allow": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_configurations_slot(self, resource_group):
        response = self.client.web_apps.list_configurations_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_application_settings_slot(self, resource_group):
        response = self.client.web_apps.update_application_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_application_settings_slot(self, resource_group):
        response = self.client.web_apps.list_application_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_auth_settings_slot(self, resource_group):
        response = self.client.web_apps.update_auth_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_auth_settings={
                "aadClaimsAuthorization": "str",
                "additionalLoginParams": ["str"],
                "allowedAudiences": ["str"],
                "allowedExternalRedirectUrls": ["str"],
                "authFilePath": "str",
                "clientId": "str",
                "clientSecret": "str",
                "clientSecretCertificateThumbprint": "str",
                "clientSecretSettingName": "str",
                "configVersion": "str",
                "defaultProvider": "str",
                "enabled": bool,
                "facebookAppId": "str",
                "facebookAppSecret": "str",
                "facebookAppSecretSettingName": "str",
                "facebookOAuthScopes": ["str"],
                "gitHubClientId": "str",
                "gitHubClientSecret": "str",
                "gitHubClientSecretSettingName": "str",
                "gitHubOAuthScopes": ["str"],
                "googleClientId": "str",
                "googleClientSecret": "str",
                "googleClientSecretSettingName": "str",
                "googleOAuthScopes": ["str"],
                "id": "str",
                "isAuthFromFile": "str",
                "issuer": "str",
                "kind": "str",
                "microsoftAccountClientId": "str",
                "microsoftAccountClientSecret": "str",
                "microsoftAccountClientSecretSettingName": "str",
                "microsoftAccountOAuthScopes": ["str"],
                "name": "str",
                "runtimeVersion": "str",
                "tokenRefreshExtensionHours": 0.0,
                "tokenStoreEnabled": bool,
                "twitterConsumerKey": "str",
                "twitterConsumerSecret": "str",
                "twitterConsumerSecretSettingName": "str",
                "type": "str",
                "unauthenticatedClientAction": "str",
                "validateIssuer": bool,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings_slot(self, resource_group):
        response = self.client.web_apps.get_auth_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings_v2_without_secrets_slot(self, resource_group):
        response = self.client.web_apps.get_auth_settings_v2_without_secrets_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_auth_settings_v2_slot(self, resource_group):
        response = self.client.web_apps.update_auth_settings_v2_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_auth_settings_v2={
                "globalValidation": {
                    "excludedPaths": ["str"],
                    "redirectToProvider": "str",
                    "requireAuthentication": bool,
                    "unauthenticatedClientAction": "str",
                },
                "httpSettings": {
                    "forwardProxy": {
                        "convention": "str",
                        "customHostHeaderName": "str",
                        "customProtoHeaderName": "str",
                    },
                    "requireHttps": bool,
                    "routes": {"apiPrefix": "str"},
                },
                "id": "str",
                "identityProviders": {
                    "apple": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "azureActiveDirectory": {
                        "enabled": bool,
                        "isAutoProvisioned": bool,
                        "login": {"disableWWWAuthenticate": bool, "loginParameters": ["str"]},
                        "registration": {
                            "clientId": "str",
                            "clientSecretCertificateIssuer": "str",
                            "clientSecretCertificateSubjectAlternativeName": "str",
                            "clientSecretCertificateThumbprint": "str",
                            "clientSecretSettingName": "str",
                            "openIdIssuer": "str",
                        },
                        "validation": {
                            "allowedAudiences": ["str"],
                            "defaultAuthorizationPolicy": {
                                "allowedApplications": ["str"],
                                "allowedPrincipals": {"groups": ["str"], "identities": ["str"]},
                            },
                            "jwtClaimChecks": {"allowedClientApplications": ["str"], "allowedGroups": ["str"]},
                        },
                    },
                    "azureStaticWebApps": {"enabled": bool, "registration": {"clientId": "str"}},
                    "customOpenIdConnectProviders": {
                        "str": {
                            "enabled": bool,
                            "login": {"nameClaimType": "str", "scopes": ["str"]},
                            "registration": {
                                "clientCredential": {"clientSecretSettingName": "str", "method": "ClientSecretPost"},
                                "clientId": "str",
                                "openIdConnectConfiguration": {
                                    "authorizationEndpoint": "str",
                                    "certificationUri": "str",
                                    "issuer": "str",
                                    "tokenEndpoint": "str",
                                    "wellKnownOpenIdConfiguration": "str",
                                },
                            },
                        }
                    },
                    "facebook": {
                        "enabled": bool,
                        "graphApiVersion": "str",
                        "login": {"scopes": ["str"]},
                        "registration": {"appId": "str", "appSecretSettingName": "str"},
                    },
                    "gitHub": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "google": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                        "validation": {"allowedAudiences": ["str"]},
                    },
                    "legacyMicrosoftAccount": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                        "validation": {"allowedAudiences": ["str"]},
                    },
                    "twitter": {
                        "enabled": bool,
                        "registration": {"consumerKey": "str", "consumerSecretSettingName": "str"},
                    },
                },
                "kind": "str",
                "login": {
                    "allowedExternalRedirectUrls": ["str"],
                    "cookieExpiration": {"convention": "str", "timeToExpiration": "str"},
                    "nonce": {"nonceExpirationInterval": "str", "validateNonce": bool},
                    "preserveUrlFragmentsForLogins": bool,
                    "routes": {"logoutEndpoint": "str"},
                    "tokenStore": {
                        "azureBlobStorage": {"sasUrlSettingName": "str"},
                        "enabled": bool,
                        "fileSystem": {"directory": "str"},
                        "tokenRefreshExtensionHours": 0.0,
                    },
                },
                "name": "str",
                "platform": {"configFilePath": "str", "enabled": bool, "runtimeVersion": "str"},
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_auth_settings_v2_slot(self, resource_group):
        response = self.client.web_apps.get_auth_settings_v2_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_azure_storage_accounts_slot(self, resource_group):
        response = self.client.web_apps.update_azure_storage_accounts_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            azure_storage_accounts={
                "id": "str",
                "kind": "str",
                "name": "str",
                "properties": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_azure_storage_accounts_slot(self, resource_group):
        response = self.client.web_apps.list_azure_storage_accounts_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_backup_configuration_slot(self, resource_group):
        response = self.client.web_apps.update_backup_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            request={
                "backupName": "str",
                "backupSchedule": {
                    "frequencyInterval": 7,
                    "frequencyUnit": "Day",
                    "keepAtLeastOneBackup": True,
                    "retentionPeriodInDays": 30,
                    "lastExecutionTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                },
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_backup_configuration_slot(self, resource_group):
        response = self.client.web_apps.delete_backup_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_backup_configuration_slot(self, resource_group):
        response = self.client.web_apps.get_backup_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_app_settings_key_vault_references_slot(self, resource_group):
        response = self.client.web_apps.get_app_settings_key_vault_references_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_app_setting_key_vault_reference_slot(self, resource_group):
        response = self.client.web_apps.get_app_setting_key_vault_reference_slot(
            resource_group_name=resource_group.name,
            name="str",
            app_setting_key="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_connection_string_key_vault_references_slot(self, resource_group):
        response = self.client.web_apps.get_site_connection_string_key_vault_references_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_connection_string_key_vault_reference_slot(self, resource_group):
        response = self.client.web_apps.get_site_connection_string_key_vault_reference_slot(
            resource_group_name=resource_group.name,
            name="str",
            connection_string_key="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_connection_strings_slot(self, resource_group):
        response = self.client.web_apps.update_connection_strings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            connection_strings={
                "id": "str",
                "kind": "str",
                "name": "str",
                "properties": {"str": {"type": "str", "value": "str"}},
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_connection_strings_slot(self, resource_group):
        response = self.client.web_apps.list_connection_strings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_diagnostic_logs_configuration_slot(self, resource_group):
        response = self.client.web_apps.get_diagnostic_logs_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_diagnostic_logs_config_slot(self, resource_group):
        response = self.client.web_apps.update_diagnostic_logs_config_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_logs_config={
                "applicationLogs": {
                    "azureBlobStorage": {"level": "str", "retentionInDays": 0, "sasUrl": "str"},
                    "azureTableStorage": {"sasUrl": "str", "level": "str"},
                    "fileSystem": {"level": "str"},
                },
                "detailedErrorMessages": {"enabled": bool},
                "failedRequestsTracing": {"enabled": bool},
                "httpLogs": {
                    "azureBlobStorage": {"enabled": bool, "retentionInDays": 0, "sasUrl": "str"},
                    "fileSystem": {"enabled": bool, "retentionInDays": 0, "retentionInMb": 0},
                },
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_metadata_slot(self, resource_group):
        response = self.client.web_apps.update_metadata_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            metadata={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_metadata_slot(self, resource_group):
        response = self.client.web_apps.list_metadata_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_list_publishing_credentials_slot(self, resource_group):
        response = self.client.web_apps.begin_list_publishing_credentials_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_site_push_settings_slot(self, resource_group):
        response = self.client.web_apps.update_site_push_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            push_settings={
                "dynamicTagsJson": "str",
                "id": "str",
                "isPushEnabled": bool,
                "kind": "str",
                "name": "str",
                "tagWhitelistJson": "str",
                "tagsRequiringAuth": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_push_settings_slot(self, resource_group):
        response = self.client.web_apps.list_site_push_settings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_configuration_slot(self, resource_group):
        response = self.client.web_apps.get_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_configuration_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_config={
                "acrUseManagedIdentityCreds": bool,
                "acrUserManagedIdentityID": "str",
                "alwaysOn": bool,
                "apiDefinition": {"url": "str"},
                "apiManagementConfig": {"id": "str"},
                "appCommandLine": "str",
                "appSettings": [{"name": "str", "value": "str"}],
                "autoHealEnabled": bool,
                "autoHealRules": {
                    "actions": {
                        "actionType": "str",
                        "customAction": {"exe": "str", "parameters": "str"},
                        "minProcessExecutionTime": "str",
                    },
                    "triggers": {
                        "privateBytesInKB": 0,
                        "requests": {"count": 0, "timeInterval": "str"},
                        "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                        "slowRequestsWithPath": [
                            {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                        ],
                        "statusCodes": [
                            {
                                "count": 0,
                                "path": "str",
                                "status": 0,
                                "subStatus": 0,
                                "timeInterval": "str",
                                "win32Status": 0,
                            }
                        ],
                        "statusCodesRange": [{"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}],
                    },
                },
                "autoSwapSlotName": "str",
                "azureStorageAccounts": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                "defaultDocuments": ["str"],
                "detailedErrorLoggingEnabled": bool,
                "documentRoot": "str",
                "elasticWebAppScaleLimit": 0,
                "experiments": {
                    "rampUpRules": [
                        {
                            "actionHostName": "str",
                            "changeDecisionCallbackUrl": "str",
                            "changeIntervalInMinutes": 0,
                            "changeStep": 0.0,
                            "maxReroutePercentage": 0.0,
                            "minReroutePercentage": 0.0,
                            "name": "str",
                            "reroutePercentage": 0.0,
                        }
                    ]
                },
                "ftpsState": "str",
                "functionAppScaleLimit": 0,
                "functionsRuntimeScaleMonitoringEnabled": bool,
                "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                "healthCheckPath": "str",
                "http20Enabled": True,
                "http20ProxyFlag": 0,
                "httpLoggingEnabled": bool,
                "id": "str",
                "ipSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "ipSecurityRestrictionsDefaultAction": "str",
                "javaContainer": "str",
                "javaContainerVersion": "str",
                "javaVersion": "str",
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                "linuxFxVersion": "str",
                "loadBalancing": "str",
                "localMySqlEnabled": False,
                "logsDirectorySizeLimit": 0,
                "machineKey": {
                    "decryption": "str",
                    "decryptionKey": "str",
                    "validation": "str",
                    "validationKey": "str",
                },
                "managedPipelineMode": "str",
                "managedServiceIdentityId": 0,
                "metadata": [{"name": "str", "value": "str"}],
                "minTlsCipherSuite": "str",
                "minTlsVersion": "str",
                "minimumElasticInstanceCount": 0,
                "name": "str",
                "netFrameworkVersion": "v4.6",
                "nodeVersion": "str",
                "numberOfWorkers": 0,
                "phpVersion": "str",
                "powerShellVersion": "str",
                "preWarmedInstanceCount": 0,
                "publicNetworkAccess": "str",
                "publishingUsername": "str",
                "push": {
                    "dynamicTagsJson": "str",
                    "id": "str",
                    "isPushEnabled": bool,
                    "kind": "str",
                    "name": "str",
                    "tagWhitelistJson": "str",
                    "tagsRequiringAuth": "str",
                    "type": "str",
                },
                "pythonVersion": "str",
                "remoteDebuggingEnabled": bool,
                "remoteDebuggingVersion": "str",
                "requestTracingEnabled": bool,
                "requestTracingExpirationTime": "2020-02-20 00:00:00",
                "scmIpSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "scmIpSecurityRestrictionsDefaultAction": "str",
                "scmIpSecurityRestrictionsUseMain": bool,
                "scmMinTlsVersion": "str",
                "scmType": "str",
                "tracingOptions": "str",
                "type": "str",
                "use32BitWorkerProcess": bool,
                "virtualApplications": [
                    {
                        "physicalPath": "str",
                        "preloadEnabled": bool,
                        "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                        "virtualPath": "str",
                    }
                ],
                "vnetName": "str",
                "vnetPrivatePortsCount": 0,
                "vnetRouteAllEnabled": bool,
                "webSocketsEnabled": bool,
                "websiteTimeZone": "str",
                "windowsFxVersion": "str",
                "xManagedServiceIdentityId": 0,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_configuration_slot(self, resource_group):
        response = self.client.web_apps.update_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_config={
                "acrUseManagedIdentityCreds": bool,
                "acrUserManagedIdentityID": "str",
                "alwaysOn": bool,
                "apiDefinition": {"url": "str"},
                "apiManagementConfig": {"id": "str"},
                "appCommandLine": "str",
                "appSettings": [{"name": "str", "value": "str"}],
                "autoHealEnabled": bool,
                "autoHealRules": {
                    "actions": {
                        "actionType": "str",
                        "customAction": {"exe": "str", "parameters": "str"},
                        "minProcessExecutionTime": "str",
                    },
                    "triggers": {
                        "privateBytesInKB": 0,
                        "requests": {"count": 0, "timeInterval": "str"},
                        "slowRequests": {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"},
                        "slowRequestsWithPath": [
                            {"count": 0, "path": "str", "timeInterval": "str", "timeTaken": "str"}
                        ],
                        "statusCodes": [
                            {
                                "count": 0,
                                "path": "str",
                                "status": 0,
                                "subStatus": 0,
                                "timeInterval": "str",
                                "win32Status": 0,
                            }
                        ],
                        "statusCodesRange": [{"count": 0, "path": "str", "statusCodes": "str", "timeInterval": "str"}],
                    },
                },
                "autoSwapSlotName": "str",
                "azureStorageAccounts": {
                    "str": {
                        "accessKey": "str",
                        "accountName": "str",
                        "mountPath": "str",
                        "protocol": "str",
                        "shareName": "str",
                        "state": "str",
                        "type": "str",
                    }
                },
                "connectionStrings": [{"connectionString": "str", "name": "str", "type": "str"}],
                "cors": {"allowedOrigins": ["str"], "supportCredentials": bool},
                "defaultDocuments": ["str"],
                "detailedErrorLoggingEnabled": bool,
                "documentRoot": "str",
                "elasticWebAppScaleLimit": 0,
                "experiments": {
                    "rampUpRules": [
                        {
                            "actionHostName": "str",
                            "changeDecisionCallbackUrl": "str",
                            "changeIntervalInMinutes": 0,
                            "changeStep": 0.0,
                            "maxReroutePercentage": 0.0,
                            "minReroutePercentage": 0.0,
                            "name": "str",
                            "reroutePercentage": 0.0,
                        }
                    ]
                },
                "ftpsState": "str",
                "functionAppScaleLimit": 0,
                "functionsRuntimeScaleMonitoringEnabled": bool,
                "handlerMappings": [{"arguments": "str", "extension": "str", "scriptProcessor": "str"}],
                "healthCheckPath": "str",
                "http20Enabled": True,
                "http20ProxyFlag": 0,
                "httpLoggingEnabled": bool,
                "id": "str",
                "ipSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "ipSecurityRestrictionsDefaultAction": "str",
                "javaContainer": "str",
                "javaContainerVersion": "str",
                "javaVersion": "str",
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "limits": {"maxDiskSizeInMb": 0, "maxMemoryInMb": 0, "maxPercentageCpu": 0.0},
                "linuxFxVersion": "str",
                "loadBalancing": "str",
                "localMySqlEnabled": False,
                "logsDirectorySizeLimit": 0,
                "machineKey": {
                    "decryption": "str",
                    "decryptionKey": "str",
                    "validation": "str",
                    "validationKey": "str",
                },
                "managedPipelineMode": "str",
                "managedServiceIdentityId": 0,
                "metadata": [{"name": "str", "value": "str"}],
                "minTlsCipherSuite": "str",
                "minTlsVersion": "str",
                "minimumElasticInstanceCount": 0,
                "name": "str",
                "netFrameworkVersion": "v4.6",
                "nodeVersion": "str",
                "numberOfWorkers": 0,
                "phpVersion": "str",
                "powerShellVersion": "str",
                "preWarmedInstanceCount": 0,
                "publicNetworkAccess": "str",
                "publishingUsername": "str",
                "push": {
                    "dynamicTagsJson": "str",
                    "id": "str",
                    "isPushEnabled": bool,
                    "kind": "str",
                    "name": "str",
                    "tagWhitelistJson": "str",
                    "tagsRequiringAuth": "str",
                    "type": "str",
                },
                "pythonVersion": "str",
                "remoteDebuggingEnabled": bool,
                "remoteDebuggingVersion": "str",
                "requestTracingEnabled": bool,
                "requestTracingExpirationTime": "2020-02-20 00:00:00",
                "scmIpSecurityRestrictions": [
                    {
                        "action": "str",
                        "description": "str",
                        "headers": {"str": ["str"]},
                        "ipAddress": "str",
                        "name": "str",
                        "priority": 0,
                        "subnetMask": "str",
                        "subnetTrafficTag": 0,
                        "tag": "str",
                        "vnetSubnetResourceId": "str",
                        "vnetTrafficTag": 0,
                    }
                ],
                "scmIpSecurityRestrictionsDefaultAction": "str",
                "scmIpSecurityRestrictionsUseMain": bool,
                "scmMinTlsVersion": "str",
                "scmType": "str",
                "tracingOptions": "str",
                "type": "str",
                "use32BitWorkerProcess": bool,
                "virtualApplications": [
                    {
                        "physicalPath": "str",
                        "preloadEnabled": bool,
                        "virtualDirectories": [{"physicalPath": "str", "virtualPath": "str"}],
                        "virtualPath": "str",
                    }
                ],
                "vnetName": "str",
                "vnetPrivatePortsCount": 0,
                "vnetRouteAllEnabled": bool,
                "webSocketsEnabled": bool,
                "websiteTimeZone": "str",
                "windowsFxVersion": "str",
                "xManagedServiceIdentityId": 0,
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_configuration_snapshot_info_slot(self, resource_group):
        response = self.client.web_apps.list_configuration_snapshot_info_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_configuration_snapshot_slot(self, resource_group):
        response = self.client.web_apps.get_configuration_snapshot_slot(
            resource_group_name=resource_group.name,
            name="str",
            snapshot_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_recover_site_configuration_snapshot_slot(self, resource_group):
        response = self.client.web_apps.recover_site_configuration_snapshot_slot(
            resource_group_name=resource_group.name,
            name="str",
            snapshot_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_web_site_container_logs_slot(self, resource_group):
        response = self.client.web_apps.get_web_site_container_logs_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_container_logs_zip_slot(self, resource_group):
        response = self.client.web_apps.get_container_logs_zip_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_continuous_web_jobs_slot(self, resource_group):
        response = self.client.web_apps.list_continuous_web_jobs_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_continuous_web_job_slot(self, resource_group):
        response = self.client.web_apps.get_continuous_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_continuous_web_job_slot(self, resource_group):
        response = self.client.web_apps.delete_continuous_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start_continuous_web_job_slot(self, resource_group):
        response = self.client.web_apps.start_continuous_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_continuous_web_job_slot(self, resource_group):
        response = self.client.web_apps.stop_continuous_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_slot_site_deployment_statuses_slot(self, resource_group):
        response = self.client.web_apps.list_slot_site_deployment_statuses_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_get_slot_site_deployment_status_slot(self, resource_group):
        response = self.client.web_apps.begin_get_slot_site_deployment_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            deployment_status_id="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_deployments_slot(self, resource_group):
        response = self.client.web_apps.list_deployments_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_deployment_slot(self, resource_group):
        response = self.client.web_apps.get_deployment_slot(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_deployment_slot(self, resource_group):
        response = self.client.web_apps.create_deployment_slot(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            slot="str",
            deployment={
                "active": bool,
                "author": "str",
                "author_email": "str",
                "deployer": "str",
                "details": "str",
                "end_time": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "message": "str",
                "name": "str",
                "start_time": "2020-02-20 00:00:00",
                "status": 0,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_deployment_slot(self, resource_group):
        response = self.client.web_apps.delete_deployment_slot(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_deployment_log_slot(self, resource_group):
        response = self.client.web_apps.list_deployment_log_slot(
            resource_group_name=resource_group.name,
            name="str",
            id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_discover_backup_slot(self, resource_group):
        response = self.client.web_apps.discover_backup_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_domain_ownership_identifiers_slot(self, resource_group):
        response = self.client.web_apps.list_domain_ownership_identifiers_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_domain_ownership_identifier_slot(self, resource_group):
        response = self.client.web_apps.get_domain_ownership_identifier_slot(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_domain_ownership_identifier_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_domain_ownership_identifier_slot(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            slot="str",
            domain_ownership_identifier={"id": "str", "kind": "str", "name": "str", "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_domain_ownership_identifier_slot(self, resource_group):
        response = self.client.web_apps.delete_domain_ownership_identifier_slot(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_domain_ownership_identifier_slot(self, resource_group):
        response = self.client.web_apps.update_domain_ownership_identifier_slot(
            resource_group_name=resource_group.name,
            name="str",
            domain_ownership_identifier_name="str",
            slot="str",
            domain_ownership_identifier={"id": "str", "kind": "str", "name": "str", "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ms_deploy_status_slot(self, resource_group):
        response = self.client.web_apps.get_ms_deploy_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_ms_deploy_operation_slot(self, resource_group):
        response = self.client.web_apps.begin_create_ms_deploy_operation_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            ms_deploy={
                "appOffline": bool,
                "connectionString": "str",
                "dbType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "packageUri": "str",
                "setParameters": {"str": "str"},
                "setParametersXmlFileUri": "str",
                "skipAppData": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_ms_deploy_log_slot(self, resource_group):
        response = self.client.web_apps.get_ms_deploy_log_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_functions_slot(self, resource_group):
        response = self.client.web_apps.list_instance_functions_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_functions_admin_token_slot(self, resource_group):
        response = self.client.web_apps.get_functions_admin_token_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_function_slot(self, resource_group):
        response = self.client.web_apps.get_instance_function_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_instance_function_slot(self, resource_group):
        response = self.client.web_apps.begin_create_instance_function_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            slot="str",
            function_envelope={
                "config": {},
                "config_href": "str",
                "files": {"str": "str"},
                "function_app_id": "str",
                "href": "str",
                "id": "str",
                "invoke_url_template": "str",
                "isDisabled": bool,
                "kind": "str",
                "language": "str",
                "name": "str",
                "script_href": "str",
                "script_root_path_href": "str",
                "secrets_file_href": "str",
                "test_data": "str",
                "test_data_href": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_instance_function_slot(self, resource_group):
        response = self.client.web_apps.delete_instance_function_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_function_secret_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_function_secret_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            key_name="str",
            slot="str",
            key={"name": "str", "value": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_function_secret_slot(self, resource_group):
        response = self.client.web_apps.delete_function_secret_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            key_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_function_keys_slot(self, resource_group):
        response = self.client.web_apps.list_function_keys_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_function_secrets_slot(self, resource_group):
        response = self.client.web_apps.list_function_secrets_slot(
            resource_group_name=resource_group.name,
            name="str",
            function_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_host_keys_slot(self, resource_group):
        response = self.client.web_apps.list_host_keys_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_sync_status_slot(self, resource_group):
        response = self.client.web_apps.list_sync_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_functions_slot(self, resource_group):
        response = self.client.web_apps.sync_functions_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_host_secret_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_host_secret_slot(
            resource_group_name=resource_group.name,
            name="str",
            key_type="str",
            key_name="str",
            slot="str",
            key={"name": "str", "value": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_host_secret_slot(self, resource_group):
        response = self.client.web_apps.delete_host_secret_slot(
            resource_group_name=resource_group.name,
            name="str",
            key_type="str",
            key_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_host_name_bindings_slot(self, resource_group):
        response = self.client.web_apps.list_host_name_bindings_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_host_name_binding_slot(self, resource_group):
        response = self.client.web_apps.get_host_name_binding_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            host_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_host_name_binding_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_host_name_binding_slot(
            resource_group_name=resource_group.name,
            name="str",
            host_name="str",
            slot="str",
            host_name_binding={
                "azureResourceName": "str",
                "azureResourceType": "str",
                "customHostNameDnsRecordType": "str",
                "domainId": "str",
                "hostNameType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "siteName": "str",
                "sslState": "str",
                "thumbprint": "str",
                "type": "str",
                "virtualIP": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_host_name_binding_slot(self, resource_group):
        response = self.client.web_apps.delete_host_name_binding_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            host_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_hybrid_connection_slot(self, resource_group):
        response = self.client.web_apps.get_hybrid_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_hybrid_connection_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_hybrid_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            slot="str",
            connection_envelope={
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "relayArmUri": "str",
                "relayName": "str",
                "sendKeyName": "str",
                "sendKeyValue": "str",
                "serviceBusNamespace": "str",
                "serviceBusSuffix": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_hybrid_connection_slot(self, resource_group):
        response = self.client.web_apps.delete_hybrid_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_hybrid_connection_slot(self, resource_group):
        response = self.client.web_apps.update_hybrid_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            namespace_name="str",
            relay_name="str",
            slot="str",
            connection_envelope={
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "relayArmUri": "str",
                "relayName": "str",
                "sendKeyName": "str",
                "sendKeyValue": "str",
                "serviceBusNamespace": "str",
                "serviceBusSuffix": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_hybrid_connections_slot(self, resource_group):
        response = self.client.web_apps.list_hybrid_connections_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_relay_service_connections_slot(self, resource_group):
        response = self.client.web_apps.list_relay_service_connections_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_relay_service_connection_slot(self, resource_group):
        response = self.client.web_apps.get_relay_service_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_relay_service_connection_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_relay_service_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            slot="str",
            connection_envelope={
                "biztalkUri": "str",
                "entityConnectionString": "str",
                "entityName": "str",
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "resourceConnectionString": "str",
                "resourceType": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_relay_service_connection_slot(self, resource_group):
        response = self.client.web_apps.delete_relay_service_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_relay_service_connection_slot(self, resource_group):
        response = self.client.web_apps.update_relay_service_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            entity_name="str",
            slot="str",
            connection_envelope={
                "biztalkUri": "str",
                "entityConnectionString": "str",
                "entityName": "str",
                "hostname": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "port": 0,
                "resourceConnectionString": "str",
                "resourceType": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_identifiers_slot(self, resource_group):
        response = self.client.web_apps.list_instance_identifiers_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_info_slot(self, resource_group):
        response = self.client.web_apps.get_instance_info_slot(
            resource_group_name=resource_group.name,
            name="str",
            instance_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_ms_deploy_status_slot(self, resource_group):
        response = self.client.web_apps.get_instance_ms_deploy_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_instance_ms_deploy_operation_slot(self, resource_group):
        response = self.client.web_apps.begin_create_instance_ms_deploy_operation_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            instance_id="str",
            ms_deploy={
                "appOffline": bool,
                "connectionString": "str",
                "dbType": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "packageUri": "str",
                "setParameters": {"str": "str"},
                "setParametersXmlFileUri": "str",
                "skipAppData": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_ms_deploy_log_slot(self, resource_group):
        response = self.client.web_apps.get_instance_ms_deploy_log_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_processes_slot(self, resource_group):
        response = self.client.web_apps.list_instance_processes_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process_slot(self, resource_group):
        response = self.client.web_apps.get_instance_process_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_instance_process_slot(self, resource_group):
        response = self.client.web_apps.delete_instance_process_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process_dump_slot(self, resource_group):
        response = self.client.web_apps.get_instance_process_dump_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_process_modules_slot(self, resource_group):
        response = self.client.web_apps.list_instance_process_modules_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_process_module_slot(self, resource_group):
        response = self.client.web_apps.get_instance_process_module_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            base_address="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_process_threads_slot(self, resource_group):
        response = self.client.web_apps.list_instance_process_threads_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            instance_id="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_is_cloneable_slot(self, resource_group):
        response = self.client.web_apps.is_cloneable_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_backups_slot(self, resource_group):
        response = self.client.web_apps.list_site_backups_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_sync_function_triggers_slot(self, resource_group):
        response = self.client.web_apps.list_sync_function_triggers_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_migrate_my_sql_status_slot(self, resource_group):
        response = self.client.web_apps.get_migrate_my_sql_status_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_swift_virtual_network_connection_slot(self, resource_group):
        response = self.client.web_apps.get_swift_virtual_network_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_swift_virtual_network_connection_with_check_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_swift_virtual_network_connection_with_check_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "subnetResourceId": "str",
                "swiftSupported": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_swift_virtual_network_slot(self, resource_group):
        response = self.client.web_apps.delete_swift_virtual_network_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_swift_virtual_network_connection_with_check_slot(self, resource_group):
        response = self.client.web_apps.update_swift_virtual_network_connection_with_check_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "subnetResourceId": "str",
                "swiftSupported": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_network_features_slot(self, resource_group):
        response = self.client.web_apps.list_network_features_slot(
            resource_group_name=resource_group.name,
            name="str",
            view="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_trace_operation_slot(self, resource_group):
        response = self.client.web_apps.get_network_trace_operation_slot(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start_web_site_network_trace_slot(self, resource_group):
        response = self.client.web_apps.start_web_site_network_trace_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_start_web_site_network_trace_operation_slot(self, resource_group):
        response = self.client.web_apps.begin_start_web_site_network_trace_operation_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_web_site_network_trace_slot(self, resource_group):
        response = self.client.web_apps.stop_web_site_network_trace_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_traces_slot(self, resource_group):
        response = self.client.web_apps.get_network_traces_slot(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_trace_operation_slot_v2(self, resource_group):
        response = self.client.web_apps.get_network_trace_operation_slot_v2(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_network_traces_slot_v2(self, resource_group):
        response = self.client.web_apps.get_network_traces_slot_v2(
            resource_group_name=resource_group.name,
            name="str",
            operation_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_generate_new_site_publishing_password_slot(self, resource_group):
        response = self.client.web_apps.generate_new_site_publishing_password_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_perf_mon_counters_slot(self, resource_group):
        response = self.client.web_apps.list_perf_mon_counters_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_php_error_log_flag_slot(self, resource_group):
        response = self.client.web_apps.get_site_php_error_log_flag_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_premier_add_ons_slot(self, resource_group):
        response = self.client.web_apps.list_premier_add_ons_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_premier_add_on_slot(self, resource_group):
        response = self.client.web_apps.get_premier_add_on_slot(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_add_premier_add_on_slot(self, resource_group):
        response = self.client.web_apps.add_premier_add_on_slot(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            slot="str",
            premier_add_on={
                "location": "str",
                "id": "str",
                "kind": "str",
                "marketplaceOffer": "str",
                "marketplacePublisher": "str",
                "name": "str",
                "product": "str",
                "sku": "str",
                "tags": {"str": "str"},
                "type": "str",
                "vendor": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_premier_add_on_slot(self, resource_group):
        response = self.client.web_apps.delete_premier_add_on_slot(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_premier_add_on_slot(self, resource_group):
        response = self.client.web_apps.update_premier_add_on_slot(
            resource_group_name=resource_group.name,
            name="str",
            premier_add_on_name="str",
            slot="str",
            premier_add_on={
                "id": "str",
                "kind": "str",
                "marketplaceOffer": "str",
                "marketplacePublisher": "str",
                "name": "str",
                "product": "str",
                "sku": "str",
                "type": "str",
                "vendor": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_access_slot(self, resource_group):
        response = self.client.web_apps.get_private_access_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_put_private_access_vnet_slot(self, resource_group):
        response = self.client.web_apps.put_private_access_vnet_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            access={
                "enabled": bool,
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "virtualNetworks": [
                    {"key": 0, "name": "str", "resourceId": "str", "subnets": [{"key": 0, "name": "str"}]}
                ],
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_endpoint_connection_list_slot(self, resource_group):
        response = self.client.web_apps.get_private_endpoint_connection_list_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_endpoint_connection_slot(self, resource_group):
        response = self.client.web_apps.get_private_endpoint_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_approve_or_reject_private_endpoint_connection_slot(self, resource_group):
        response = self.client.web_apps.begin_approve_or_reject_private_endpoint_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            slot="str",
            private_endpoint_wrapper={
                "id": "str",
                "ipAddresses": ["str"],
                "kind": "str",
                "name": "str",
                "privateEndpoint": {"id": "str"},
                "privateLinkServiceConnectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_delete_private_endpoint_connection_slot(self, resource_group):
        response = self.client.web_apps.begin_delete_private_endpoint_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            slot="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_private_link_resources_slot(self, resource_group):
        response = self.client.web_apps.get_private_link_resources_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_processes_slot(self, resource_group):
        response = self.client.web_apps.list_processes_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process_slot(self, resource_group):
        response = self.client.web_apps.get_process_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_process_slot(self, resource_group):
        response = self.client.web_apps.delete_process_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process_dump_slot(self, resource_group):
        response = self.client.web_apps.get_process_dump_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_process_modules_slot(self, resource_group):
        response = self.client.web_apps.list_process_modules_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_process_module_slot(self, resource_group):
        response = self.client.web_apps.get_process_module_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            base_address="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_process_threads_slot(self, resource_group):
        response = self.client.web_apps.list_process_threads_slot(
            resource_group_name=resource_group.name,
            name="str",
            process_id="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_public_certificates_slot(self, resource_group):
        response = self.client.web_apps.list_public_certificates_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_public_certificate_slot(self, resource_group):
        response = self.client.web_apps.get_public_certificate_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            public_certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_public_certificate_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_public_certificate_slot(
            resource_group_name=resource_group.name,
            name="str",
            public_certificate_name="str",
            slot="str",
            public_certificate={
                "blob": bytes("bytes", encoding="utf-8"),
                "id": "str",
                "kind": "str",
                "name": "str",
                "publicCertificateLocation": "str",
                "thumbprint": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_public_certificate_slot(self, resource_group):
        response = self.client.web_apps.delete_public_certificate_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            public_certificate_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_publishing_profile_xml_with_secrets_slot(self, resource_group):
        response = self.client.web_apps.list_publishing_profile_xml_with_secrets_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            publishing_profile_options={"format": "str", "includeDisasterRecoveryEndpoints": bool},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_reset_slot_configuration_slot(self, resource_group):
        response = self.client.web_apps.reset_slot_configuration_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_restart_slot(self, resource_group):
        response = self.client.web_apps.restart_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_from_backup_blob_slot(self, resource_group):
        response = self.client.web_apps.begin_restore_from_backup_blob_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            request={
                "adjustConnectionStrings": bool,
                "appServicePlan": "str",
                "blobName": "str",
                "databases": [
                    {"databaseType": "str", "connectionString": "str", "connectionStringName": "str", "name": "str"}
                ],
                "hostingEnvironment": "str",
                "id": "str",
                "ignoreConflictingHostNames": False,
                "ignoreDatabases": False,
                "kind": "str",
                "name": "str",
                "operationType": "Default",
                "overwrite": bool,
                "siteName": "str",
                "storageAccountUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_from_deleted_app_slot(self, resource_group):
        response = self.client.web_apps.begin_restore_from_deleted_app_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            restore_request={
                "deletedSiteId": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "recoverConfiguration": bool,
                "snapshotTime": "str",
                "type": "str",
                "useDRSecondary": bool,
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_restore_snapshot_slot(self, resource_group):
        response = self.client.web_apps.begin_restore_snapshot_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            restore_request={
                "id": "str",
                "ignoreConflictingHostNames": bool,
                "kind": "str",
                "name": "str",
                "overwrite": bool,
                "recoverConfiguration": bool,
                "recoverySource": {"id": "str", "location": "str"},
                "snapshotTime": "str",
                "type": "str",
                "useDRSecondary": bool,
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_containers_slot(self, resource_group):
        response = self.client.web_apps.list_site_containers_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_container_slot(self, resource_group):
        response = self.client.web_apps.get_site_container_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            container_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_site_container_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_site_container_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            container_name="str",
            request={
                "authType": "str",
                "createdTime": "2020-02-20 00:00:00",
                "environmentVariables": [{"name": "str", "value": "str"}],
                "id": "str",
                "image": "str",
                "inheritAppSettingsAndConnectionStrings": bool,
                "isMain": bool,
                "kind": "str",
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "passwordSecret": "str",
                "startUpCommand": "str",
                "targetPort": "str",
                "type": "str",
                "userManagedIdentityClientId": "str",
                "userName": "str",
                "volumeMounts": [
                    {"containerMountPath": "str", "volumeSubPath": "str", "data": "str", "readOnly": bool}
                ],
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_site_container_slot(self, resource_group):
        response = self.client.web_apps.delete_site_container_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            container_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_site_extensions_slot(self, resource_group):
        response = self.client.web_apps.list_site_extensions_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_site_extension_slot(self, resource_group):
        response = self.client.web_apps.get_site_extension_slot(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_install_site_extension_slot(self, resource_group):
        response = self.client.web_apps.begin_install_site_extension_slot(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            slot="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_site_extension_slot(self, resource_group):
        response = self.client.web_apps.delete_site_extension_slot(
            resource_group_name=resource_group.name,
            name="str",
            site_extension_id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_slot_differences_slot(self, resource_group):
        response = self.client.web_apps.list_slot_differences_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_swap_slot(self, resource_group):
        response = self.client.web_apps.begin_swap_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_snapshots_slot(self, resource_group):
        response = self.client.web_apps.list_snapshots_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_snapshots_from_dr_secondary_slot(self, resource_group):
        response = self.client.web_apps.list_snapshots_from_dr_secondary_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_source_control_slot(self, resource_group):
        response = self.client.web_apps.get_source_control_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_or_update_source_control_slot(self, resource_group):
        response = self.client.web_apps.begin_create_or_update_source_control_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_source_control={
                "branch": "str",
                "deploymentRollbackEnabled": bool,
                "gitHubActionConfiguration": {
                    "codeConfiguration": {"runtimeStack": "str", "runtimeVersion": "str"},
                    "containerConfiguration": {
                        "imageName": "str",
                        "password": "str",
                        "serverUrl": "str",
                        "username": "str",
                    },
                    "generateWorkflowFile": bool,
                    "isLinux": bool,
                },
                "id": "str",
                "isGitHubAction": bool,
                "isManualIntegration": bool,
                "isMercurial": bool,
                "kind": "str",
                "name": "str",
                "repoUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_source_control_slot(self, resource_group):
        response = self.client.web_apps.delete_source_control_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_source_control_slot(self, resource_group):
        response = self.client.web_apps.update_source_control_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            site_source_control={
                "branch": "str",
                "deploymentRollbackEnabled": bool,
                "gitHubActionConfiguration": {
                    "codeConfiguration": {"runtimeStack": "str", "runtimeVersion": "str"},
                    "containerConfiguration": {
                        "imageName": "str",
                        "password": "str",
                        "serverUrl": "str",
                        "username": "str",
                    },
                    "generateWorkflowFile": bool,
                    "isLinux": bool,
                },
                "id": "str",
                "isGitHubAction": bool,
                "isManualIntegration": bool,
                "isMercurial": bool,
                "kind": "str",
                "name": "str",
                "repoUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start_slot(self, resource_group):
        response = self.client.web_apps.start_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_start_network_trace_slot(self, resource_group):
        response = self.client.web_apps.begin_start_network_trace_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_slot(self, resource_group):
        response = self.client.web_apps.stop_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_network_trace_slot(self, resource_group):
        response = self.client.web_apps.stop_network_trace_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_repository_slot(self, resource_group):
        response = self.client.web_apps.sync_repository_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_function_triggers_slot(self, resource_group):
        response = self.client.web_apps.sync_function_triggers_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_triggered_web_jobs_slot(self, resource_group):
        response = self.client.web_apps.list_triggered_web_jobs_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_triggered_web_job_slot(self, resource_group):
        response = self.client.web_apps.get_triggered_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_triggered_web_job_slot(self, resource_group):
        response = self.client.web_apps.delete_triggered_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_triggered_web_job_history_slot(self, resource_group):
        response = self.client.web_apps.list_triggered_web_job_history_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_triggered_web_job_history_slot(self, resource_group):
        response = self.client.web_apps.get_triggered_web_job_history_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            id="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_run_triggered_web_job_slot(self, resource_group):
        response = self.client.web_apps.run_triggered_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_usages_slot(self, resource_group):
        response = self.client.web_apps.list_usages_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_vnet_connections_slot(self, resource_group):
        response = self.client.web_apps.list_vnet_connections_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_vnet_connection_slot(self, resource_group):
        response = self.client.web_apps.get_vnet_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_vnet_connection_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_vnet_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            slot="str",
            connection_envelope={
                "certBlob": "str",
                "certThumbprint": "str",
                "dnsServers": "str",
                "id": "str",
                "isSwift": bool,
                "kind": "str",
                "name": "str",
                "resyncRequired": bool,
                "routes": [
                    {
                        "endAddress": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "routeType": "str",
                        "startAddress": "str",
                        "type": "str",
                    }
                ],
                "type": "str",
                "vnetResourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_vnet_connection_slot(self, resource_group):
        response = self.client.web_apps.delete_vnet_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_vnet_connection_slot(self, resource_group):
        response = self.client.web_apps.update_vnet_connection_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            slot="str",
            connection_envelope={
                "certBlob": "str",
                "certThumbprint": "str",
                "dnsServers": "str",
                "id": "str",
                "isSwift": bool,
                "kind": "str",
                "name": "str",
                "resyncRequired": bool,
                "routes": [
                    {
                        "endAddress": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "routeType": "str",
                        "startAddress": "str",
                        "type": "str",
                    }
                ],
                "type": "str",
                "vnetResourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_vnet_connection_gateway_slot(self, resource_group):
        response = self.client.web_apps.get_vnet_connection_gateway_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_vnet_connection_gateway_slot(self, resource_group):
        response = self.client.web_apps.create_or_update_vnet_connection_gateway_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            slot="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "vnetName": "str",
                "vpnPackageUri": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_vnet_connection_gateway_slot(self, resource_group):
        response = self.client.web_apps.update_vnet_connection_gateway_slot(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            slot="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "vnetName": "str",
                "vpnPackageUri": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_web_jobs_slot(self, resource_group):
        response = self.client.web_apps.list_web_jobs_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_web_job_slot(self, resource_group):
        response = self.client.web_apps.get_web_job_slot(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_slot_differences_from_production(self, resource_group):
        response = self.client.web_apps.list_slot_differences_from_production(
            resource_group_name=resource_group.name,
            name="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_swap_slot_with_production(self, resource_group):
        response = self.client.web_apps.begin_swap_slot_with_production(
            resource_group_name=resource_group.name,
            name="str",
            slot_swap_entity={"preserveVnet": bool, "targetSlot": "str"},
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_snapshots(self, resource_group):
        response = self.client.web_apps.list_snapshots(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_snapshots_from_dr_secondary(self, resource_group):
        response = self.client.web_apps.list_snapshots_from_dr_secondary(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_source_control(self, resource_group):
        response = self.client.web_apps.get_source_control(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_create_or_update_source_control(self, resource_group):
        response = self.client.web_apps.begin_create_or_update_source_control(
            resource_group_name=resource_group.name,
            name="str",
            site_source_control={
                "branch": "str",
                "deploymentRollbackEnabled": bool,
                "gitHubActionConfiguration": {
                    "codeConfiguration": {"runtimeStack": "str", "runtimeVersion": "str"},
                    "containerConfiguration": {
                        "imageName": "str",
                        "password": "str",
                        "serverUrl": "str",
                        "username": "str",
                    },
                    "generateWorkflowFile": bool,
                    "isLinux": bool,
                },
                "id": "str",
                "isGitHubAction": bool,
                "isManualIntegration": bool,
                "isMercurial": bool,
                "kind": "str",
                "name": "str",
                "repoUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_source_control(self, resource_group):
        response = self.client.web_apps.delete_source_control(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_source_control(self, resource_group):
        response = self.client.web_apps.update_source_control(
            resource_group_name=resource_group.name,
            name="str",
            site_source_control={
                "branch": "str",
                "deploymentRollbackEnabled": bool,
                "gitHubActionConfiguration": {
                    "codeConfiguration": {"runtimeStack": "str", "runtimeVersion": "str"},
                    "containerConfiguration": {
                        "imageName": "str",
                        "password": "str",
                        "serverUrl": "str",
                        "username": "str",
                    },
                    "generateWorkflowFile": bool,
                    "isLinux": bool,
                },
                "id": "str",
                "isGitHubAction": bool,
                "isManualIntegration": bool,
                "isMercurial": bool,
                "kind": "str",
                "name": "str",
                "repoUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_start(self, resource_group):
        response = self.client.web_apps.start(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_begin_start_network_trace(self, resource_group):
        response = self.client.web_apps.begin_start_network_trace(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop(self, resource_group):
        response = self.client.web_apps.stop(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_stop_network_trace(self, resource_group):
        response = self.client.web_apps.stop_network_trace(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_repository(self, resource_group):
        response = self.client.web_apps.sync_repository(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_sync_function_triggers(self, resource_group):
        response = self.client.web_apps.sync_function_triggers(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_triggered_web_jobs(self, resource_group):
        response = self.client.web_apps.list_triggered_web_jobs(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_triggered_web_job(self, resource_group):
        response = self.client.web_apps.get_triggered_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_triggered_web_job(self, resource_group):
        response = self.client.web_apps.delete_triggered_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_triggered_web_job_history(self, resource_group):
        response = self.client.web_apps.list_triggered_web_job_history(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_triggered_web_job_history(self, resource_group):
        response = self.client.web_apps.get_triggered_web_job_history(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            id="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_run_triggered_web_job(self, resource_group):
        response = self.client.web_apps.run_triggered_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_usages(self, resource_group):
        response = self.client.web_apps.list_usages(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_vnet_connections(self, resource_group):
        response = self.client.web_apps.list_vnet_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_vnet_connection(self, resource_group):
        response = self.client.web_apps.get_vnet_connection(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_vnet_connection(self, resource_group):
        response = self.client.web_apps.create_or_update_vnet_connection(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            connection_envelope={
                "certBlob": "str",
                "certThumbprint": "str",
                "dnsServers": "str",
                "id": "str",
                "isSwift": bool,
                "kind": "str",
                "name": "str",
                "resyncRequired": bool,
                "routes": [
                    {
                        "endAddress": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "routeType": "str",
                        "startAddress": "str",
                        "type": "str",
                    }
                ],
                "type": "str",
                "vnetResourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_delete_vnet_connection(self, resource_group):
        response = self.client.web_apps.delete_vnet_connection(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_vnet_connection(self, resource_group):
        response = self.client.web_apps.update_vnet_connection(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            connection_envelope={
                "certBlob": "str",
                "certThumbprint": "str",
                "dnsServers": "str",
                "id": "str",
                "isSwift": bool,
                "kind": "str",
                "name": "str",
                "resyncRequired": bool,
                "routes": [
                    {
                        "endAddress": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "routeType": "str",
                        "startAddress": "str",
                        "type": "str",
                    }
                ],
                "type": "str",
                "vnetResourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_vnet_connection_gateway(self, resource_group):
        response = self.client.web_apps.get_vnet_connection_gateway(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_create_or_update_vnet_connection_gateway(self, resource_group):
        response = self.client.web_apps.create_or_update_vnet_connection_gateway(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "vnetName": "str",
                "vpnPackageUri": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_update_vnet_connection_gateway(self, resource_group):
        response = self.client.web_apps.update_vnet_connection_gateway(
            resource_group_name=resource_group.name,
            name="str",
            vnet_name="str",
            gateway_name="str",
            connection_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "vnetName": "str",
                "vpnPackageUri": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_web_jobs(self, resource_group):
        response = self.client.web_apps.list_web_jobs(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_web_job(self, resource_group):
        response = self.client.web_apps.get_web_job(
            resource_group_name=resource_group.name,
            name="str",
            web_job_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_deploy_workflow_artifacts(self, resource_group):
        response = self.client.web_apps.deploy_workflow_artifacts(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_deploy_workflow_artifacts_slot(self, resource_group):
        response = self.client.web_apps.deploy_workflow_artifacts_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_instance_workflows_slot(self, resource_group):
        response = self.client.web_apps.list_instance_workflows_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_instance_workflow_slot(self, resource_group):
        response = self.client.web_apps.get_instance_workflow_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            workflow_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_workflows_connections_slot(self, resource_group):
        response = self.client.web_apps.list_workflows_connections_slot(
            resource_group_name=resource_group.name,
            name="str",
            slot="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_workflows(self, resource_group):
        response = self.client.web_apps.list_workflows(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_get_workflow(self, resource_group):
        response = self.client.web_apps.get_workflow(
            resource_group_name=resource_group.name,
            name="str",
            workflow_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_apps_list_workflows_connections(self, resource_group):
        response = self.client.web_apps.list_workflows_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...
