#define XERR "memoryaccess"
#include "memoryaccess.ih"

// create() constructs a new MemoryAccess object. It's called by the
// MemoryBridge constructor receiving a memory size (like 2MB). The 
// MemoryBridge constructor receiving an ID doesn't allocate, but directly
// loads it, using the loadID member, sharing the already allocated
// MemoryAccess object.

    // by memorybridge3.cc

// static
MemoryAccess *MemoryAccess::create(string const &bufSize, size_t access)
{
    size_t nBlocks;
    size_t blockSize;

    cptSizes(&nBlocks, &blockSize, bufSize);

                                                    // get the Access's ID
    int id = getID(memoryAccessSize(nBlocks), access);

                                                    // get its location
    MemoryAccess *ptr = static_cast<MemoryAccess *>(connect(id));

    if (ptr == 0)
        throw Exception{} << XERR ": can't connect memory for a "
                            "MemoryAccess object (id = " << id << ')';

                                                // placement new installation
                                                // of a MemoryAccess object
    new (ptr) MemoryAccess(id, access, nBlocks, blockSize);
    ptr->d_blockStep = nBlocks;

    return ptr;
}



//xerr("nBlocks: " << nBlocks << ", blockSize: " << blockSize);

//MemoryAccess *MemoryAccess::create(int *id, string const &bufSize, 


//    return allocate(id, nBlocks, blockSize, access);

//xerr("   size(MemoryAccess): " << sizeof(MemoryAccess) << 
//    ", sizeof MemoryID: " << sizeof(MemoryID) << '\n' << 
//    "   required total MemoryAccess size: " << 
//    (sizeof(MemoryAccess) + (nBlocks - 1) * sizeof(MemoryID)));

