/*
 *  Copyright (C) 2005-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#include "InputCodingTableBasePY.h"

#include "ServiceBroker.h"
#include "guilib/GUIComponent.h"
#include "guilib/GUIMessage.h"
#include "guilib/GUIWindowManager.h"
#include "utils/CharsetConverter.h"

#include <stdlib.h>

static std::map<std::string, std::wstring> codemap = {
    {"a", L"啊阿吖嗄腌锕"},
    {"ai", L"爱矮挨哎碍癌艾唉哀蔼隘埃皑嗌嫒瑷暧捱砹嗳锿霭"},
    {"an", L"按安暗岸俺案鞍氨胺庵揞犴铵桉谙鹌埯黯"},
    {"ang", L"昂肮盎"},
    {"ao", L"袄凹傲奥熬懊敖翱澳拗媪廒骜嗷坳遨聱螯獒鏊鳌鏖岙"},
    {"ba", L"把八吧爸拔罢跋巴芭扒坝霸叭靶笆疤耙捌粑茇岜鲅钯魃菝灞"},
    {"bai", L"百白摆败柏拜佰伯稗捭掰"},
    {"ban", L"半办班般拌搬版斑板伴扳扮瓣颁绊癍坂钣舨阪瘢"},
    {"bang", L"帮棒绑磅镑邦榜蚌傍梆膀谤浜蒡"},
    {"bao", L"包抱报饱保暴薄宝爆剥豹刨雹褒堡苞胞鲍炮龅孢煲褓鸨趵葆勹"},
    {"bei", L"被北倍杯背悲备碑卑贝辈钡焙狈惫臂褙悖蓓鹎鐾呗邶鞴孛陂碚埤萆"},
    {"ben", L"本奔苯笨锛贲畚坌"},
    {"beng", L"蹦绷甭崩迸蚌泵甏嘣堋"},
    {"bi", L"比笔闭鼻碧必避逼毕臂彼鄙壁蓖币弊辟蔽毙庇敝陛毖痹秘泌秕薜荸芘萆匕裨畀俾嬖狴筚箅篦舭荜襞"
           L"庳铋跸吡愎贲滗濞璧哔髀弼妣婢埤"},
    {"bian", L"边变便遍编辩扁贬鞭卞辨辫忭砭匾汴碥蝙褊鳊笾苄窆弁缏煸"},
    {"biao", L"表标彪膘杓婊飑飙鳔瘭飚镳裱骠镖灬髟"},
    {"bie", L"别憋鳖瘪蹩"},
    {"bin", L"宾濒摈彬斌滨豳膑殡缤髌傧槟鬓镔玢"},
    {"bing", L"并病兵冰丙饼屏秉柄炳摒槟禀邴冫"},
    {"bo", L"拨波播泊博伯驳玻剥薄勃菠钵搏脖帛柏舶渤铂箔膊卜礴跛檗亳鹁踣啵蕃簸钹饽擘孛百趵"},
    {"bu", L"不步补布部捕卜簿哺堡埠怖埔瓿逋晡钸钚醭卟"},
    {"ca", L"擦礤嚓"},
    {"cai", L"才菜采材财裁猜踩睬蔡彩"},
    {"can", L"蚕残掺参惨惭餐灿骖璨孱黪粲"},
    {"cang", L"藏仓沧舱苍伧"},
    {"cao", L"草操曹槽糙嘈艚螬漕艹"},
    {"ce", L"册侧策测厕恻"},
    {"cen", L"参岑涔"},
    {"ceng", L"曾层蹭噌"},
    {"cha", L"查插叉茶差岔搽察茬碴刹诧楂槎镲衩汊馇檫姹杈锸嚓猹"},
    {"chai", L"柴拆差豺钗瘥虿侪龇"},
    {"chan", L"产缠掺搀阐颤铲谗蝉单馋觇婵蒇谄冁廛孱蟾羼镡忏潺禅躔澶"},
    {"chang", L"长唱常场厂尝肠畅昌敞倡偿猖鲳氅菖惝嫦徜鬯阊怅伥昶苌娼"},
    {"chao", L"朝抄超吵潮巢炒嘲剿绰钞怊耖晁"},
    {"che", L"车撤扯掣彻澈坼砗屮"},
    {"chen", L"趁称辰臣尘晨沉陈衬忱郴榇抻谌碜谶宸龀嗔琛"},
    {"cheng", L"成乘盛撑称城程呈诚秤惩逞骋澄橙承塍柽埕铖噌铛酲裎枨蛏丞瞠徵"},
    {"chi", L"吃尺迟池翅痴赤齿耻持斥侈弛驰炽匙踟坻茌墀饬媸豉褫敕哧瘛蚩啻鸱眵螭篪魑叱彳笞嗤傺"},
    {"chong", L"冲重虫充宠崇种艟忡舂铳憧茺"},
    {"chou", L"抽愁臭仇丑稠绸酬筹踌畴瞅惆俦帱瘳雠"},
    {"chu", L"出处初锄除触橱楚础储畜滁矗搐躇厨雏楮杵刍怵绌亍憷蹰黜蜍樗褚"},
    {"chuai", L"揣膪嘬搋踹"},
    {"chuan", L"穿船传串川喘椽氚遄钏舡舛巛"},
    {"chuang", L"窗床闯创疮幢怆"},
    {"chui", L"吹垂炊锤捶槌棰陲"},
    {"chun", L"春唇纯蠢醇淳椿蝽莼鹑"},
    {"chuo", L"戳绰踔啜龊辍辶"},
    {"ci", L"次此词瓷慈雌磁辞刺茨伺疵赐差兹呲鹚祠糍粢茈"},
    {"cong", L"从丛葱匆聪囱琮枞淙璁骢苁"},
    {"cou", L"凑楱辏腠"},
    {"cu", L"粗醋簇促徂猝蔟蹙酢殂蹴"},
    {"cuan", L"窜蹿篡攒汆爨镩撺"},
    {"cui", L"催脆摧翠崔淬瘁粹璀啐悴萃毳榱隹"},
    {"cun", L"村寸存忖皴"},
    {"cuo", L"错撮搓挫措磋嵯厝鹾脞痤蹉瘥锉矬躜"},
    {"da", L"大答达打搭瘩笪耷哒褡疸怛靼妲沓嗒鞑"},
    {"dai", L"带代呆戴待袋逮歹贷怠傣大殆呔玳迨岱甙黛骀绐埭"},
    {"dan", L"但单蛋担弹掸胆淡丹耽旦氮诞郸惮石疸澹瘅萏殚眈聃箪赕儋啖赡"},
    {"dang", L"当党挡档荡谠铛宕菪凼裆砀"},
    {"dao", L"到道倒刀岛盗稻捣悼导蹈祷帱纛忉焘氘叨刂"},
    {"de", L"的地得德锝"},
    {"dei", L"得"},
    {"deng", L"等灯邓登澄瞪凳蹬磴镫噔嶝戥簦"},
    {"di", L"地第底低敌抵滴帝递嫡弟缔堤的涤提笛迪狄翟蒂觌邸谛诋嘀柢骶羝氐棣睇娣荻碲镝坻籴砥"},
    {"dia", L"嗲"},
    {"dian", L"点电店殿淀掂颠垫碘惦奠典佃靛滇甸踮钿坫阽癫簟玷巅癜"},
    {"diao", L"掉钓叼吊雕调刁碉凋铞铫鲷貂"},
    {"die", L"爹跌叠碟蝶迭谍牒堞瓞揲蹀耋鲽垤喋"},
    {"ding", L"顶定盯订叮丁钉鼎锭町玎铤腚碇疔仃耵酊啶"},
    {"diu", L"丢铥"},
    {"dong", L"动东懂洞冻冬董栋侗恫峒鸫胨胴硐氡岽咚"},
    {"dou", L"都斗豆逗陡抖痘兜蚪窦篼蔸"},
    {"du", L"读度毒渡堵独肚镀赌睹杜督都犊妒蠹笃嘟渎椟牍黩髑芏"},
    {"duan", L"段短断端锻缎椴煅簖"},
    {"dui", L"对队堆兑碓怼憝"},
    {"dun", L"吨顿蹲墩敦钝盾囤遁趸沌盹镦礅炖砘"},
    {"duo", L"多朵夺舵剁垛跺惰堕掇哆驮度躲踱沲咄铎裰哚缍"},
    {"e", L"饿哦额鹅蛾扼俄讹阿遏峨娥恶厄鄂锇谔垩锷萼苊轭婀莪鳄颚腭愕呃噩鹗屙"},
    {"ei", L"诶"},
    {"en", L"恩摁蒽"},
    {"er", L"而二耳儿饵尔贰洱珥鲕鸸迩铒"},
    {"fa", L"发法罚伐乏筏阀珐垡砝"},
    {"fan", L"反饭翻番犯凡帆返泛繁烦贩范樊藩矾钒燔蘩畈蕃蹯梵幡"},
    {"fang", L"放房防纺芳方访仿坊妨肪钫邡枋舫鲂匚"},
    {"fei", L"非飞肥费肺废匪吠沸菲诽啡篚蜚腓扉妃斐狒芾悱镄霏翡榧淝鲱绯痱砩"},
    {"fen", L"分份芬粉坟奋愤纷忿粪酚焚吩氛汾棼瀵鲼玢偾鼢贲"},
    {"feng", L"风封逢缝蜂丰枫疯冯奉讽凤峰锋烽砜俸酆葑沣唪"},
    {"fo", L"佛"},
    {"fou", L"否缶"},
    {"fu", L"副幅扶浮富福负伏付复服附俯斧赴缚拂夫父符孵敷赋辅府腐腹妇抚覆辐肤氟佛俘傅讣弗涪袱甫釜脯"
           L"腑阜咐黼砩苻趺跗蚨芾鲋幞茯滏蜉拊菔蝠鳆蝮绂绋赙罘稃匐麸凫桴莩孚馥驸怫祓呋郛芙艴黻哺阝"},
    {"ga", L"噶夹嘎咖钆伽旮尬尕尜"},
    {"gai", L"该改盖概钙芥溉戤垓丐陔赅胲"},
    {"gan", L"赶干感敢竿甘肝柑杆赣秆旰酐矸疳泔苷擀绀橄澉淦尴坩"},
    {"gang", L"刚钢纲港缸岗杠冈肛扛筻罡戆"},
    {"gao", L"高搞告稿膏篙羔糕镐皋郜诰杲缟睾槔锆槁藁"},
    {"ge", L"个各歌割哥搁格阁隔革咯胳葛蛤戈鸽疙盖合铬骼袼塥虼圪镉仡舸鬲嗝膈搿纥哿铪"},
    {"gei", L"给"},
    {"gen", L"跟根哏茛亘艮"},
    {"geng", L"更耕颈梗耿庚羹埂赓鲠哽绠"},
    {"gong", L"工公功共弓攻宫供恭拱贡躬巩汞龚肱觥珙蚣廾"},
    {"gou", L"够沟狗钩勾购构苟垢岣彀枸鞲觏缑笱诟遘媾篝佝"},
    {"gu", L"古股鼓谷故孤箍姑顾固雇估咕骨辜沽蛊贾菇梏鸪汩轱崮菰鹄鹘钴臌酤鲴诂牯瞽毂锢牿痼觚蛄罟嘏"},
    {"gua", L"挂刮瓜寡剐褂卦呱胍鸹栝诖"},
    {"guai", L"怪拐乖掴"},
    {"guan", L"关管官观馆惯罐灌冠贯棺纶盥莞掼涫鳏鹳倌"},
    {"guang", L"光广逛桄犷咣胱"},
    {"gui", L"归贵鬼跪轨规硅桂柜龟诡闺瑰圭刽癸炔庋宄桧刿鳜鲑皈匦妫晷簋炅"},
    {"gun", L"滚棍辊鲧衮磙绲"},
    {"guo", L"过国果裹锅郭涡埚椁聒馘猓崞掴帼呙虢蜾蝈锞"},
    {"ha", L"哈蛤铪"},
    {"hai", L"还海害咳氦孩骇咳骸亥嗨醢胲"},
    {"han", L"喊含汗寒汉旱酣韩焊涵函憨翰罕撼捍憾悍邯邗菡撖瀚顸蚶焓颔晗鼾"},
    {"hang", L"行巷航夯杭吭颃沆绗"},
    {"hao", L"好号浩嚎壕郝毫豪耗貉镐昊颢灏嚆蚝嗥皓蒿濠薅"},
    {"he", L"和喝合河禾核何呵荷贺赫褐盒鹤菏貉阂涸吓嗬劾盍翮阖颌壑诃纥曷蚵"},
    {"hei", L"黑嘿"},
    {"hen", L"很狠恨痕"},
    {"heng", L"横恒哼衡亨桁珩蘅"},
    {"hong", L"红轰哄虹洪宏烘鸿弘讧訇蕻闳薨黉荭泓"},
    {"hou", L"后厚吼喉侯候猴鲎篌堠後逅糇骺瘊"},
    {"hu", L"湖户呼虎壶互胡护糊弧忽狐蝴葫沪乎核瑚唬鹕冱怙鹱笏戽扈鹘浒祜醐琥囫烀轷瓠煳斛鹄猢惚岵滹觳"
           L"唿槲虍"},
    {"hua", L"话花化画华划滑哗猾铧桦骅砉"},
    {"huai", L"坏怀淮槐徊踝"},
    {"huan", L"换还唤环患缓欢幻宦涣焕豢桓痪漶獾擐逭鲩郇鬟寰奂锾圜洹萑缳浣垸"},
    {"huang", L"黄慌晃荒簧凰皇谎惶蝗磺恍煌幌隍肓潢篁徨鳇遑癀湟蟥璜"},
    {"hui", L"回会灰绘挥汇辉毁悔惠晦徽恢秽慧贿蛔讳卉烩诲彗浍蕙喙恚哕晖隳麾诙蟪茴洄咴虺荟缋桧"},
    {"hun", L"混昏荤浑婚魂阍珲馄溷诨"},
    {"huo", L"或活火伙货和获祸豁霍惑嚯镬耠劐藿攉锪蠖钬夥"},
    {"ji", L"几及急既即机鸡积记级极计挤己季寄纪系基激吉脊际汲肌嫉姬绩缉饥迹棘蓟技冀辑伎祭剂悸济籍寂"
           L"奇忌妓继集给击圾箕讥畸稽疾墼洎鲚屐齑戟鲫嵇矶稷戢虮笈暨笄剞叽蒺跻嵴掎跽霁唧畿荠瘠玑羁丌"
           L"偈芨佶赍楫髻咭蕺觊麂骥殛岌亟犄乩芰哜彐萁藉"},
    {"jia", L"家加假价架甲佳夹嘉驾嫁枷荚颊钾稼茄贾铗葭迦戛浃镓痂恝岬跏嘏伽胛笳珈瘕郏袈蛱袷铪"},
    {"jian", L"见件减尖间键贱肩兼建检箭煎简剪歼监坚奸健艰荐剑渐溅涧鉴践捡柬笺俭碱硷拣舰槛缄茧饯翦鞯"
             L"戋谏牮枧腱趼缣搛戬毽菅鲣笕谫楗囝蹇裥踺睑謇鹣蒹僭锏湔犍谮"},
    {"jiang", L"将讲江奖降浆僵姜酱蒋疆匠强桨虹豇礓缰犟耩绛茳糨洚"},
    {"jiao", L"叫脚交角教较缴觉焦胶娇绞校搅骄狡浇矫郊嚼蕉轿窖椒礁饺铰酵侥剿徼艽僬蛟敫峤跤姣皎茭鹪噍"
             L"醮佼鲛挢"},
    {"jie",
     L"接节街借皆截解界结届姐揭戒介阶劫芥竭洁疥藉秸桔杰捷诫睫偈桀喈拮骱羯蚧嗟颉鲒婕碣讦孑疖诘卩锴"},
    {"jin", L"进近今仅紧金斤尽劲禁浸锦晋筋津谨巾襟烬靳廑瑾馑槿衿堇荩矜噤缙卺妗赆觐钅"},
    {"jing",
     L"竟静井惊经镜京净敬精景警竞境径荆晶鲸粳颈兢茎睛劲痉靖肼獍阱腈弪刭憬婧胫菁儆旌迳靓泾陉"},
    {"jiong", L"窘炯扃迥冂"},
    {"jiu", L"就九酒旧久揪救纠舅究韭厩臼玖灸咎疚赳鹫僦柩桕鬏鸠阄啾"},
    {"ju", L"句举巨局具距锯剧居聚拘菊矩沮拒惧鞠狙驹据柜俱车咀疽踞炬倨醵裾屦犋苴窭飓锔椐苣琚掬榘龃趄"
           L"莒雎遽橘踽榉鞫钜讵枸瞿蘧"},
    {"juan", L"卷圈倦鹃捐娟眷绢鄄锩蠲镌狷桊涓隽"},
    {"jue", L"决绝觉角爵掘诀撅倔抉攫嚼脚桷橛觖劂爝矍镢獗珏崛蕨噘谲蹶孓厥阙"},
    {"jun", L"军君均菌俊峻龟竣骏钧浚郡筠麇皲捃"},
    {"ka", L"卡喀咯咖胩咔佧"},
    {"kai", L"开揩凯慨楷垲剀锎铠锴忾恺蒈"},
    {"kan", L"看砍堪刊坎槛勘龛戡侃瞰莰阚凵"},
    {"kang", L"抗炕扛糠康慷亢钪闶伉"},
    {"kao", L"靠考烤拷栲犒尻铐"},
    {"ke", L"可克棵科颗刻课客壳渴苛柯磕咳坷呵恪岢蝌缂蚵轲窠钶氪颏瞌锞稞珂髁疴嗑溘骒铪"},
    {"ken", L"肯啃恳垦裉"},
    {"keng", L"坑吭铿胫铒"},
    {"kong", L"空孔控恐倥崆箜"},
    {"kou", L"口扣抠寇蔻芤眍筘叩"},
    {"ku", L"哭库苦枯裤窟酷刳骷喾堀绔"},
    {"kua", L"跨垮挎夸胯侉锞"},
    {"kuai", L"快块筷会侩哙蒯郐狯脍"},
    {"kuan", L"宽款髋"},
    {"kuang", L"矿筐狂框况旷匡眶诳邝纩夼诓圹贶哐"},
    {"kui", L"亏愧奎窥溃葵魁馈盔傀岿匮愦揆睽跬聩篑喹逵暌蒉悝喟馗蝰隗夔"},
    {"kun", L"捆困昆坤鲲锟髡琨醌阃悃顽"},
    {"kuo", L"阔扩括廓蛞"},
    {"la", L"拉啦辣蜡腊喇垃落瘌邋砬剌旯"},
    {"lai", L"来赖莱濑赉崃涞铼籁徕癞睐"},
    {"lan", L"蓝兰烂拦篮懒栏揽缆滥阑谰婪澜览榄岚褴镧斓罱漤"},
    {"lang", L"浪狼廊郎朗榔琅稂螂莨啷锒阆蒗"},
    {"lao", L"老捞牢劳烙涝落姥酪络佬耢铹醪铑唠栳崂痨"},
    {"le", L"了乐勒鳓仂叻泐"},
    {"lei", L"类累泪雷垒勒擂蕾肋镭儡磊缧诔耒酹羸嫘檑嘞"},
    {"leng", L"冷棱楞愣塄"},
    {"li", L"里离力立李例哩理利梨厘礼历丽吏砾漓莉傈荔俐痢狸粒沥隶栗璃鲤厉励犁黎篱郦鹂笠坜苈鳢缡跞蜊"
           L"锂澧粝蓠枥蠡鬲呖砺嫠篥疠疬猁藜溧鲡戾栎唳醴轹詈骊罹逦俪喱雳黧莅俚蛎娌砬"},
    {"lia", L"俩"},
    {"lian", L"连联练莲恋脸炼链敛怜廉帘镰涟蠊琏殓蔹鲢奁潋臁裢濂裣楝"},
    {"liang", L"两亮辆凉粮梁量良晾谅俩粱墚踉椋魉莨"},
    {"liao", L"了料撩聊撂疗廖燎辽僚寥镣潦钌蓼尥寮缭獠鹩嘹"},
    {"lie", L"列裂猎劣烈咧埒捩鬣趔躐冽洌"},
    {"lin", L"林临淋邻磷鳞赁吝拎琳霖凛遴嶙蔺粼麟躏辚廪懔瞵檩膦啉"},
    {"ling", L"另令领零铃玲灵岭龄凌陵菱伶羚棱翎蛉苓绫瓴酃呤泠棂柃鲮聆囹"},
    {"liu", L"六流留刘柳溜硫瘤榴琉馏碌陆绺锍鎏镏浏骝旒鹨熘遛"},
    {"lo", L"咯"},
    {"long", L"龙拢笼聋隆垄弄咙窿陇垅胧珑茏泷栊癃砻"},
    {"lou", L"楼搂漏陋露娄篓偻蝼镂蒌耧髅喽瘘嵝"},
    {"lu",
     L"路露录鹿陆炉卢鲁卤芦颅庐碌掳绿虏赂戮潞禄麓六鲈栌渌逯泸轳氇簏橹辂垆胪噜镥辘漉撸璐鸬鹭舻"},
    {"luan", L"乱卵滦峦孪挛栾銮脔娈鸾"},
    {"lue", L"略掠锊"},
    {"lun", L"论轮抡伦沦仑纶囵"},
    {"luo", L"落罗锣裸骡烙箩螺萝洛骆逻络咯荦漯蠃雒倮硌椤捋脶瘰摞泺珞镙猡铬"},
    {"lv", L"绿率铝驴旅屡滤吕律氯缕侣虑履偻膂榈闾捋褛稆"},
    {"lve", L"略掠锊"},
    {"m", L"呒"},
    {"ma", L"吗妈马嘛麻骂抹码玛蚂摩唛蟆犸嬷杩"},
    {"mai", L"买卖迈埋麦脉劢霾荬"},
    {"man", L"满慢瞒漫蛮蔓曼馒埋谩幔鳗墁螨镘颟鞔缦熳"},
    {"mang", L"忙芒盲莽茫氓硭邙蟒漭"},
    {"mao", L"毛冒帽猫矛卯貌茂贸铆锚茅耄茆瑁蝥髦懋昴牦瞀峁袤蟊旄泖"},
    {"me", L"么"},
    {"mei", L"没每煤镁美酶妹枚霉玫眉梅寐昧媒媚嵋猸袂湄浼鹛莓魅镅楣"},
    {"men", L"门们闷懑扪钔焖"},
    {"meng", L"猛梦蒙锰孟盟檬萌礞蜢勐懵甍蠓虻朦艋艨瞢"},
    {"mi", L"米密迷眯蜜谜觅秘弥幂靡糜泌醚蘼縻咪汨麋祢猕弭谧芈脒宓敉嘧糸冖"},
    {"mian", L"面棉免绵眠缅勉冕娩腼湎眄沔渑宀"},
    {"miao", L"秒苗庙妙描瞄藐渺眇缪缈淼喵杪鹋邈"},
    {"mie", L"灭蔑咩篾蠛乜"},
    {"min", L"民抿敏闽皿悯珉愍缗闵玟苠泯黾鳘岷"},
    {"ming", L"名明命鸣铭螟冥瞑暝茗溟酩"},
    {"miu", L"谬缪"},
    {"mo", L"摸磨抹末膜墨没莫默魔模摩摹漠陌蘑脉沫万寞秣瘼殁镆嫫谟蓦貊貘麽茉馍耱"},
    {"mou", L"某谋牟眸蛑鍪侔缪哞"},
    {"mu", L"木母亩幕目墓牧牟模穆暮牡拇募慕睦姆钼毪坶沐仫苜"},
    {"na", L"那拿哪纳钠娜呐衲捺镎肭"},
    {"nai", L"乃耐奶奈氖萘艿柰鼐佴"},
    {"nan", L"难南男赧囡蝻楠喃腩"},
    {"nang", L"囊馕曩囔攮"},
    {"nao", L"闹脑恼挠淖孬铙瑙垴呶蛲猱硇"},
    {"ne", L"呢哪讷"},
    {"nei", L"内馁"},
    {"nen", L"嫩恁"},
    {"neng", L"能"},
    {"ng", L"嗯"},
    {"ni", L"你泥拟腻逆呢溺倪尼匿妮霓铌昵坭祢猊伲怩鲵睨旎慝"},
    {"nian", L"年念捻撵拈碾蔫廿黏辇鲇鲶埝"},
    {"niang", L"娘酿"},
    {"niao", L"鸟尿袅茑脲嬲"},
    {"nie", L"捏镍聂孽涅镊啮陧蘖嗫臬蹑颞乜"},
    {"nin", L"您"},
    {"ning", L"拧凝宁柠狞泞佞甯咛聍"},
    {"niu", L"牛扭纽钮拗妞狃忸"},
    {"nong", L"弄浓农脓哝侬"},
    {"nou", L"耨"},
    {"nu", L"怒努奴孥胬驽弩"},
    {"nuan", L"暖"},
    {"nue", L"虐疟"},
    {"nuo", L"挪诺懦糯娜喏傩锘搦"},
    {"nv", L"女衄钕恧"},
    {"nve", L"虐疟"},
    {"o", L"哦喔噢"},
    {"ou", L"偶呕欧藕鸥区沤殴怄瓯讴耦"},
    {"pa", L"怕爬趴啪耙扒帕琶筢杷葩"},
    {"pai", L"派排拍牌迫徘湃哌俳蒎"},
    {"pan", L"盘盼判攀畔潘叛磐番胖襻蟠袢泮拚爿蹒"},
    {"pang", L"旁胖耪庞乓膀磅滂彷逄螃镑"},
    {"pao", L"跑抛炮泡刨袍咆狍匏庖疱脬"},
    {"pei", L"陪配赔呸胚佩培沛裴旆锫帔醅霈辔"},
    {"pen", L"喷盆湓"},
    {"peng", L"碰捧棚砰蓬朋彭鹏烹硼膨抨澎篷怦堋蟛嘭"},
    {"pi", L"批皮披匹劈辟坯屁脾僻疲痞霹琵毗啤譬砒否貔丕圮媲癖仳擗郫甓枇睥蜱鼙邳陂铍庀罴埤纰陴淠噼蚍"
           L"裨疋芘"},
    {"pian", L"片篇骗偏便扁翩缏犏骈胼蹁谝"},
    {"piao", L"忄票飘漂瓢朴螵嫖瞟殍缥嘌骠剽"},
    {"pie", L"瞥撇氕苤丿"},
    {"pin", L"品贫聘拼频嫔榀姘牝颦"},
    {"ping", L"平凭瓶评屏乒萍苹坪冯娉鲆枰俜"},
    {"po", L"破坡颇婆泼迫泊魄朴繁粕笸皤钋陂鄱攴叵珀钷"},
    {"pou", L"剖掊裒"},
    {"pu", L"扑铺谱脯仆蒲葡朴菩曝莆瀑埔圃浦堡普暴镨噗匍溥濮氆蹼璞镤"},
    {"qi", L"起其七气期齐器妻骑汽棋奇欺漆启戚柒岂砌弃泣祁凄企乞契歧祈栖畦脐崎稽迄缉沏讫旗祺颀骐屺岐"
           L"蹊蕲桤憩芪荠萋芑汔亟鳍俟槭嘁蛴綦亓欹琪麒琦蜞圻杞葺碛淇耆绮綮"},
    {"qia", L"恰卡掐洽髂袷葜"},
    {"qian", L"前钱千牵浅签欠铅嵌钎迁钳乾谴谦潜歉纤扦遣黔堑仟岍钤褰箝掮搴倩慊悭愆虔芡荨缱佥芊阡肷茜"
             L"椠犍骞羟赶"},
    {"qiang", L"强枪墙抢腔呛羌蔷蜣跄戗襁戕炝镪锵羟樯嫱"},
    {"qiao", L"桥瞧敲巧翘锹壳鞘撬悄俏窍雀乔侨峭橇樵荞跷硗憔谯鞒愀缲诮劁峤搞铫"},
    {"qie", L"切且怯窃茄郄趄惬锲妾箧慊伽挈"},
    {"qin", L"亲琴侵勤擒寝秦芹沁禽钦吣覃矜衾芩廑嗪螓噙揿檎锓"},
    {"qing", L"请轻清青情晴氢倾庆擎顷亲卿氰圊謦檠箐苘蜻黥罄鲭磬綮"},
    {"qiong", L"穷琼跫穹邛蛩茕銎筇"},
    {"qiu", L"求球秋丘泅仇邱囚酋龟楸蚯裘糗蝤巯逑俅虬赇鳅犰湫遒"},
    {"qu", L"去取区娶渠曲趋趣屈驱蛆躯龋戌蠼蘧祛蕖磲劬诎鸲阒麴癯衢黢璩氍觑蛐朐瞿岖苣"},
    {"quan", L"全权劝圈拳犬泉券颧痊醛铨筌绻诠辁畎鬈悛蜷荃犭"},
    {"que", L"却缺确雀瘸鹊炔榷阙阕悫"},
    {"qun", L"群裙麇逡"},
    {"ran", L"染燃然冉髯苒蚺"},
    {"rang", L"让嚷瓤攘壤穰禳"},
    {"rao", L"饶绕扰荛桡娆"},
    {"re", L"热惹喏"},
    {"ren", L"人任忍认刃仁韧妊纫壬饪轫仞荏葚衽稔亻"},
    {"reng", L"仍扔"},
    {"ri", L"日"},
    {"rong", L"容绒融溶熔荣戎蓉冗茸榕狨嵘肜蝾"},
    {"rou", L"肉揉柔糅蹂鞣"},
    {"ru", L"如入汝儒茹乳褥辱蠕孺蓐襦铷嚅缛濡薷颥溽洳"},
    {"ruan", L"软阮朊"},
    {"rui", L"瑞蕊锐睿芮蚋枘蕤"},
    {"run", L"润闰"},
    {"ruo", L"若弱箬偌"},
    {"sa", L"撒洒萨仨卅飒脎"},
    {"sai", L"塞腮鳃赛噻"},
    {"san", L"三散伞叁馓糁毵"},
    {"sang", L"桑丧嗓颡磉搡"},
    {"sao", L"扫嫂搔骚埽鳋臊缫瘙"},
    {"se", L"色涩瑟塞啬铯穑"},
    {"sen", L"森"},
    {"seng", L"僧"},
    {"sha", L"杀沙啥纱傻砂刹莎厦煞杉唼鲨霎铩痧裟歃"},
    {"shai", L"晒筛色"},
    {"shan", L"山闪衫善扇杉删煽单珊掺赡栅苫膳陕汕擅缮嬗蟮芟禅跚鄯潸鳝姗剡骟疝膻讪钐舢埏彡髟"},
    {"shang", L"上伤尚商赏晌墒裳熵觞绱殇垧"},
    {"shao", L"少烧捎哨勺梢稍邵韶绍芍鞘苕劭潲艄蛸筲"},
    {"she", L"社射蛇设舌摄舍折涉赊赦慑奢歙厍畲猞麝滠佘揲"},
    {"shei", L"谁"},
    {"shen", L"身伸深婶神甚渗肾审申沈绅呻参砷什娠慎葚莘诜谂矧椹渖蜃哂胂"},
    {"sheng", L"声省剩生升绳胜盛圣甥牲乘晟渑眚笙嵊"},
    {"shi", L"是使十时事室市石师试史式识虱矢拾屎驶始似示士世柿匙拭誓逝势什殖峙嗜噬失适仕侍释饰氏狮"
            L"食恃蚀视实施湿诗尸豕莳埘铈舐鲥鲺贳轼蓍筮炻谥弑酾螫礻铊饣"},
    {"shou", L"手受收首守瘦授兽售寿艏狩绶扌"},
    {"shu", L"书树数熟输梳叔属束术述蜀黍鼠淑赎孰蔬疏戍竖墅庶薯漱恕枢暑殊抒曙署舒姝摅秫纾沭毹腧塾菽"
            L"殳澍倏疋镯"},
    {"shua", L"刷耍唰"},
    {"shuai", L"摔甩率帅衰蟀"},
    {"shuan", L"栓拴闩涮"},
    {"shuang", L"双霜爽泷孀"},
    {"shui", L"水睡税说氵"},
    {"shun", L"顺吮瞬舜"},
    {"shuo", L"说数硕烁朔搠妁槊蒴铄"},
    {"si", L"四死丝撕似私嘶思寺司斯伺肆饲嗣巳耜驷兕蛳厮汜锶泗笥咝鸶姒厶缌祀澌俟徙"},
    {"song", L"送松耸宋颂诵怂讼竦菘淞悚嵩凇崧忪"},
    {"sou", L"艘搜擞嗽嗾嗖飕叟薮锼馊瞍溲螋"},
    {"su", L"素速诉塑宿俗苏肃粟酥缩溯僳愫簌觫稣夙嗉谡蔌涑"},
    {"suan", L"酸算蒜狻"},
    {"sui", L"岁随碎虽穗遂尿隋髓绥隧祟眭谇濉邃燧荽睢"},
    {"sun", L"孙损笋榫荪飧狲隼"},
    {"suo", L"所缩锁琐索梭蓑莎唆挲睃嗍唢桫嗦娑羧"},
    {"ta", L"他她它踏塔塌拓獭挞蹋溻趿鳎沓榻漯遢铊闼"},
    {"tai", L"太抬台态胎苔泰酞汰炱肽跆鲐钛薹邰骀"},
    {"tan", L"谈叹探滩弹碳摊潭贪坛痰毯坦炭瘫谭坍檀袒钽郯镡锬覃澹昙忐赕"},
    {"tang", L"躺趟堂糖汤塘烫倘淌唐搪棠膛螳樘羰醣瑭镗傥饧溏耥帑铴螗铛"},
    {"tao", L"套掏逃桃讨淘涛滔陶绦萄鼗洮焘啕饕韬叨"},
    {"te", L"特铽忑忒"},
    {"teng", L"疼腾藤誊滕"},
    {"ti", L"提替体题踢蹄剃剔梯锑啼涕嚏惕屉醍鹈绨缇倜裼逖荑悌"},
    {"tian", L"天田添填甜舔恬腆掭钿阗忝殄畋锘"},
    {"tiao", L"条跳挑调迢眺龆笤祧蜩髫佻窕鲦苕粜铫"},
    {"tie", L"铁贴帖萜餮锇"},
    {"ting", L"听停挺厅亭艇庭廷烃汀莛铤葶婷蜓梃霆"},
    {"tong", L"同通痛铜桶筒捅统童彤桐瞳酮潼茼仝砼峒恸佟嗵垌僮"},
    {"tou", L"头偷透投钭骰亠"},
    {"tu", L"土图兔涂吐秃突徒凸途屠酴荼钍菟堍"},
    {"tuan", L"团湍疃抟彖"},
    {"tui", L"腿推退褪颓蜕煺"},
    {"tun", L"吞屯褪臀囤氽饨豚暾"},
    {"tuo", L"拖脱托妥驮拓驼椭唾鸵陀橐柝跎乇坨佗庹酡柁鼍沱箨砣说铊"},
    {"wa", L"挖瓦蛙哇娃洼袜佤娲腽"},
    {"wai", L"外歪崴"},
    {"wan", L"完万晚碗玩弯挽湾丸腕宛婉烷顽豌惋皖蔓莞脘蜿绾芄琬纨剜畹菀"},
    {"wang", L"望忘王往网亡枉旺汪妄辋魍惘罔尢"},
    {"wei", L"为位未围喂胃微味尾伪威伟卫危违委魏唯维畏惟韦巍蔚谓尉潍纬慰桅萎苇渭葳帏艉鲔娓逶闱隈沩"
            L"玮涠帷崴隗诿洧偎猥猬嵬軎韪炜煨圩薇痿囗"},
    {"wen", L"问文闻稳温吻蚊纹瘟紊汶阌刎雯璺"},
    {"weng", L"翁嗡瓮蕹蓊"},
    {"wo", L"我握窝卧挝沃蜗涡斡倭幄龌肟莴喔渥硪"},
    {"wu", L"无五屋物舞雾误捂污悟勿钨武戊务呜伍吴午吾侮乌毋恶诬芜巫晤梧坞妩蜈牾寤兀怃阢邬唔忤骛於鋈"
           L"仵杌鹜婺迕痦芴焐庑鹉鼯浯圬"},
    {"xi", L"西洗细吸戏系喜席稀溪熄锡膝息袭惜习嘻夕悉矽熙希檄牺晰昔媳硒铣烯析隙汐犀蜥奚浠葸饩屣玺嬉"
           L"禊兮翕穸禧僖淅蓰舾蹊醯郗欷皙蟋羲茜徙隰唏曦螅歙樨阋粞熹觋菥鼷裼舄"},
    {"xia", L"下吓夏峡虾瞎霞狭匣侠辖厦暇狎柙呷黠硖罅遐瑕"},
    {"xian", L"先线县现显掀闲献嫌陷险鲜弦衔馅限咸锨仙腺贤纤宪舷涎羡铣苋藓岘痫莶籼娴蚬猃祆冼燹跣跹酰"
             L"暹氙鹇筅霰洗"},
    {"xiang", L"想向象项响香乡相像箱巷享镶厢降翔祥橡详湘襄飨鲞骧蟓庠芗饷缃葙"},
    {"xiao", L"小笑消削销萧效宵晓肖孝硝淆啸霄哮嚣校魈蛸骁枵哓筱潇逍枭绡箫"},
    {"xie",
     L"写些鞋歇斜血谢卸挟屑蟹泻懈泄楔邪协械谐蝎携胁解叶绁颉缬獬榭廨撷偕瀣渫亵榍邂薤躞燮勰骱鲑"},
    {"xin", L"新心欣信芯薪锌辛衅忻歆囟莘镡馨鑫昕忄"},
    {"xing", L"性行型形星醒姓腥刑杏兴幸邢猩惺省硎悻荥陉擤荇研饧"},
    {"xiong", L"胸雄凶兄熊汹匈芎"},
    {"xiu", L"修锈绣休羞宿嗅袖秀朽臭溴貅馐髹鸺咻庥岫"},
    {"xu", L"许须需虚嘘蓄续序叙畜絮婿戌徐旭绪吁酗恤墟糈勖栩浒蓿顼圩洫胥醑诩溆煦盱"},
    {"xuan", L"选悬旋玄宣喧轩绚眩癣券暄楦儇渲漩泫铉璇煊碹镟炫揎萱谖"},
    {"xue", L"学雪血靴穴削薛踅噱鳕泶谑"},
    {"xun", L"寻讯熏训循殉旬巡迅驯汛逊勋询浚巽鲟浔埙恂獯醺洵郇峋蕈薰荀窨曛徇荨"},
    {"ya", L"呀压牙押芽鸭轧崖哑亚涯丫雅衙鸦讶蚜垭疋砑琊桠睚娅痖岈氩伢迓揠"},
    {"yan", L"眼烟沿盐言演严咽淹炎掩厌宴岩研延堰验艳殷阉砚雁唁彦焰蜒衍谚燕颜阎铅焉奄芫厣阏菸魇琰滟"
            L"焱赝筵腌兖剡餍恹罨檐湮偃谳胭晏闫俨郾酽鄢妍鼹崦阽嫣涎讠"},
    {"yang", L"样养羊洋仰扬秧氧痒杨漾阳殃央鸯佯疡炀恙徉鞅泱蛘烊怏"},
    {"yao", L"要摇药咬腰窑舀邀妖谣遥姚瑶耀尧钥侥疟珧夭鳐鹞轺爻吆铫幺崾肴曜徭杳窈啮繇"},
    {"ye", L"也夜业野叶爷页液掖腋冶噎耶咽曳椰邪谒邺晔烨揶铘靥"},
    {"yi", L"一以已亿衣移依易医乙仪亦椅益倚姨翼译伊遗艾胰疑沂宜异彝壹蚁谊揖铱矣翌艺抑绎邑屹尾役臆逸"
           L"肄疫颐裔意毅忆义夷溢诣议怿痍镒癔怡驿旖熠酏翊欹峄圯殪咦懿噫劓诒饴漪佚咿瘗猗眙羿弈苡荑佾"
           L"贻钇缢迤刈悒黟翳弋奕蜴埸挹嶷薏呓轶镱舣奇硪衤铊"},
    {"yin", L"因引印银音饮阴隐荫吟尹寅茵淫殷姻堙鄞喑夤胤龈吲狺垠霪蚓氤铟窨瘾洇茚廴"},
    {"ying", L"应硬影营迎映蝇赢鹰英颖莹盈婴樱缨荧萤萦楹蓥瘿茔鹦媵莺璎郢嘤撄瑛滢潆嬴罂瀛膺荥颍"},
    {"yo", L"哟育唷"},
    {"yong", L"用涌永拥蛹勇雍咏泳佣踊痈庸臃恿壅慵俑墉鳙邕喁甬饔镛"},
    {"you",
     L"有又由右油游幼优友铀忧尤犹诱悠邮酉佑釉幽疣攸蚰莠鱿卣黝莸猷蚴宥牖囿柚蝣莜鼬铕蝤繇呦侑尢"},
    {"yu", L"与于欲鱼雨余遇语愈狱玉渔予誉育愚羽虞娱淤舆屿禹宇迂俞逾域芋郁吁盂喻峪御愉渝尉榆隅浴寓裕"
           L"预豫驭蔚妪嵛雩馀阈窬鹆妤揄窳觎臾舁龉蓣煜钰谀纡於竽瑜禺聿欤俣伛圄鹬庾昱萸瘐谕鬻圉瘀熨饫"
           L"毓燠腴狳菀蜮蝓吾"},
    {"yuan", L"远员元院圆原愿园援猿怨冤源缘袁渊苑垣鸳辕圜鼋橼媛爰眢鸢掾芫沅瑗螈箢塬"},
    {"yue", L"月越约跃阅乐岳悦曰说粤钥瀹钺刖龠栎樾哕"},
    {"yun", L"云运晕允匀韵陨孕耘蕴酝郧员氲恽愠郓芸筠韫昀狁殒纭熨"},
    {"za", L"杂砸咋匝扎咂拶"},
    {"zai", L"在再灾载栽宰哉甾崽"},
    {"zan", L"咱暂攒赞簪趱糌瓒拶昝錾"},
    {"zang", L"脏葬赃藏臧驵"},
    {"zao", L"早造遭糟灶燥枣凿躁藻皂噪澡蚤唣"},
    {"ze", L"则责择泽咋箦舴帻迮啧仄昃笮赜"},
    {"zei", L"贼"},
    {"zen", L"怎谮"},
    {"zeng", L"增赠憎曾缯罾甑锃"},
    {"zha", L"扎炸渣闸眨榨乍轧诈铡札查栅咋喳砟痄吒哳楂蚱揸喋柞咤齄龃"},
    {"zhai", L"摘窄债斋寨择翟宅砦瘵"},
    {"zhan", L"站占战盏沾粘毡展栈詹颤蘸湛绽斩辗崭瞻谵搌旃骣"},
    {"zhang", L"张章长帐仗丈掌涨账樟杖彰漳胀瘴障仉嫜幛鄣璋嶂獐蟑"},
    {"zhao", L"找着照招罩爪兆朝昭沼肇召赵棹啁钊笊诏"},
    {"zhe", L"着这者折遮蛰哲蔗锗辙浙柘辄赭摺鹧磔褶蜇谪"},
    {"zhen", L"真阵镇针震枕振斟珍疹诊甄砧臻贞侦缜蓁祯箴轸榛稹赈朕鸩胗浈桢畛圳椹溱"},
    {"zheng", L"正整睁争挣征怔证症郑拯蒸狰政峥钲铮筝诤徵鲭"},
    {"zhi", L"只之直知制指纸支芝枝稚吱蜘质肢脂汁炙织职痔植抵殖执值侄址滞止趾治旨窒志挚掷至致置帜识"
            L"峙智秩帙摭黹桎枳轵忮祉蛭膣觯郅栀彘芷祗咫鸷絷踬胝骘轾痣陟踯雉埴贽卮酯豸跖栉夂徵"},
    {"zhong", L"中重种钟肿众终盅忠仲衷踵舯螽锺冢忪"},
    {"zhou", L"周洲皱粥州轴舟昼骤宙诌肘帚咒繇胄纣荮啁碡绉籀妯酎"},
    {"zhu", L"住主猪竹株煮筑著贮铸嘱拄注祝驻属术珠瞩蛛朱柱诸诛逐助烛蛀潴洙伫瘃翥茱苎橥舳杼箸炷侏铢"
            L"疰渚褚躅麈邾槠竺丶"},
    {"zhua", L"抓爪挝"},
    {"zhuai", L"拽转"},
    {"zhuan", L"转专砖赚传撰篆颛馔啭沌"},
    {"zhuang", L"装撞庄壮桩状幢妆奘戆"},
    {"zhui", L"追坠缀锥赘椎骓惴缒隹"},
    {"zhun", L"准谆肫窀饨"},
    {"zhuo", L"捉桌着啄拙灼浊卓琢茁酌擢焯濯诼浞涿倬镯禚斫淖"},
    {"zi", L"字自子紫籽资姿吱滓仔兹咨孜渍滋淄笫粢龇秭恣谘趑缁梓鲻锱孳耔觜髭赀茈訾嵫眦姊辎"},
    {"zong", L"总纵宗棕综踪鬃偬粽枞腙"},
    {"zou", L"走揍奏邹鲰鄹陬驺诹"},
    {"zu", L"组族足阻租祖诅菹镞卒俎"},
    {"zuan", L"钻纂缵躜攥"},
    {"zui", L"最嘴醉罪觜蕞"},
    {"zun", L"尊遵鳟撙樽"},
    {"zuo", L"做作坐左座昨琢撮佐嘬酢唑祚胙怍阼柞砟"},
};

CInputCodingTableBasePY::CInputCodingTableBasePY()
{
  m_codechars = "abcdefghijklmnopqrstuvwxyz";
}

std::vector<std::wstring> CInputCodingTableBasePY::GetResponse(int)
{
  return m_words;
}

bool CInputCodingTableBasePY::GetWordListPage(const std::string& strCode, bool isFirstPage)
{
  if (!isFirstPage)
    return false;

  m_words.clear();
  auto finder = codemap.find(strCode);
  if (finder != codemap.end())
  {
    for (unsigned int i = 0; i < finder->second.size(); i++)
    {
      m_words.push_back(finder->second.substr(i, 1));
    }
  }
  CGUIMessage msg(GUI_MSG_CODINGTABLE_LOOKUP_COMPLETED, 0, 0, 0);
  msg.SetStringParam(strCode);
  CServiceBroker::GetGUI()->GetWindowManager().SendThreadMessage(
      msg, CServiceBroker::GetGUI()->GetWindowManager().GetActiveWindowOrDialog());
  return true;
}
